/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.sql;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.ow2.petals.bc.sql.DriverResolver;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;

public class DataSources {
    private Logger logger;
    private Map<Provides, DataSource> dataSources;

    public DataSources(Logger logger) {
        this.logger = logger;
        this.dataSources = new ConcurrentHashMap<Provides, DataSource>();
    }

    public DataSource createDataSourceForService(ConfigurationExtensions extensions) {
        BasicDataSource jdbcDataSource = new BasicDataSource();
        String url = extensions.get((Object)"url");
        String driver = extensions.get((Object)"driver");
        if (StringHelper.isNullOrEmpty((String)driver)) {
            driver = DriverResolver.resolveDriverClassname(url);
        }
        String user = extensions.get((Object)"user");
        String password = extensions.get((Object)"password");
        jdbcDataSource.setUrl(url);
        jdbcDataSource.setDriverClassName(driver);
        jdbcDataSource.setUsername(user);
        jdbcDataSource.setPassword(password);
        String maxActive = extensions.get((Object)"maxActive");
        String maxIdle = extensions.get((Object)"maxIdle");
        String minIdle = extensions.get((Object)"minIdle");
        String maxWait = extensions.get((Object)"maxWait");
        String timeBEviction = extensions.get((Object)"timeBetweenEvictionRunsMillis");
        if (maxActive != null) {
            jdbcDataSource.setMaxActive(Integer.parseInt(maxActive));
        }
        if (maxIdle != null) {
            jdbcDataSource.setMaxIdle(Integer.parseInt(maxIdle));
        }
        if (minIdle != null) {
            jdbcDataSource.setMinIdle(Integer.parseInt(minIdle));
        }
        if (maxWait != null) {
            jdbcDataSource.setMaxWait((long)Integer.parseInt(maxWait));
        }
        if (timeBEviction != null) {
            jdbcDataSource.setTimeBetweenEvictionRunsMillis((long)Integer.parseInt(timeBEviction));
        }
        this.logger.finest("Create a dataSource with parameters :\n" + DataSources.printDataSourceInfo((DataSource)jdbcDataSource));
        return jdbcDataSource;
    }

    public void addDataSource(Provides key, DataSource dataSource) {
        this.dataSources.put(key, dataSource);
    }

    public DataSource getDataSource(Provides key) {
        return this.dataSources.get(key);
    }

    public Set<Provides> getDataSourceKeys() {
        return this.dataSources.keySet();
    }

    public DataSource removeDataSource(Provides key) throws PEtALSCDKException {
        return this.dataSources.remove(key);
    }

    public final void closeDataSource(DataSource dataSource) {
        try {
            ((BasicDataSource)dataSource).close();
        }
        catch (SQLException e) {
            this.logger.log(Level.WARNING, "The following JDBC DataSource has not been closed properly.\n" + DataSources.printDataSourceInfo(dataSource));
        }
    }

    public static final String printDataSourceInfo(DataSource dataSource) {
        StringBuilder info = new StringBuilder();
        BasicDataSource bds = (BasicDataSource)dataSource;
        info.append("url           :" + bds.getUrl());
        info.append("\n");
        info.append("driver        :" + bds.getDriverClassName());
        info.append("\n");
        info.append("user          :" + bds.getUsername());
        info.append("\n");
        info.append("password      :" + bds.getPassword());
        info.append("\n");
        info.append("maxActive     :" + bds.getMaxActive());
        info.append("\n");
        info.append("maxIdle       :" + bds.getMaxIdle());
        info.append("\n");
        info.append("minIdle       :" + bds.getMinIdle());
        info.append("\n");
        info.append("maxWait       :" + bds.getMaxWait());
        info.append("\n");
        info.append("timeBEviction :" + bds.getTimeBetweenEvictionRunsMillis());
        return info.toString();
    }
}

