/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process.async;

import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.component.framework.process.async.AsyncContextExchange;

public class AsyncContextCleaner
extends TimerTask {
    private final Map<String, AsyncContextExchange> asynchronousContexts;
    private final JBIProcessorManager jbiProcessorManager;
    private final int nbMaxTry;
    private final long baseWaitDuration;
    private final Logger logger;

    public AsyncContextCleaner(Map<String, AsyncContextExchange> asynchronousContexts, JBIProcessorManager jbiProcessorManager, int nbMaxTry, long baseWaitDuration, Logger logger) {
        this.asynchronousContexts = asynchronousContexts;
        this.jbiProcessorManager = jbiProcessorManager;
        this.nbMaxTry = nbMaxTry;
        this.baseWaitDuration = baseWaitDuration;
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            for (Map.Entry<String, AsyncContextExchange> asyncContextExchangeEntry : this.asynchronousContexts.entrySet()) {
                AsyncContextExchange asyncContextExchange = asyncContextExchangeEntry.getValue();
                AsyncContext asyncContext = asyncContextExchange.asyncContext;
                long expirationTime = asyncContext.getExpirationTime();
                if (expirationTime == 0L || System.currentTimeMillis() <= expirationTime) continue;
                Exchange exchange = asyncContextExchange.exchange;
                exchange.setProperty("org.ow2.petals.component.framework.asynchronous.expired", (Object)Boolean.TRUE);
                this.jbiProcessorManager.process((ExchangeImpl)exchange, this.nbMaxTry, this.baseWaitDuration);
            }
        }
        catch (InterruptedException e1) {
            this.logger.fine("The processing of expired asynchronous messages is interrupted.");
        }
    }
}

