/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.dump;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.io.File;
import org.ow2.petals.commons.logger.TraceCode;

public class DumpFileGenerator {
    static final String DUMP_FILE_EXTENSION = ".xml";
    static final String FILENAME_SEPARATOR = "_";
    static String LOG_BASEDIR;

    public static final File getDumpFile(TraceCode traceCode) {
        String dumpDir = DumpFileGenerator.getDumpDirPath();
        String dumpFileName = DumpFileGenerator.getContextualDumpFileName(traceCode);
        File dumpFile = new File(dumpDir, dumpFileName);
        return dumpFile;
    }

    private static final String getContextualDumpFileName(TraceCode traceCode) {
        String flowStepId = ExecutionContext.getProperties().getProperty("flowStepId");
        if (flowStepId == null) {
            flowStepId = "unknown";
        }
        return flowStepId + FILENAME_SEPARATOR + (Object)((Object)traceCode) + DUMP_FILE_EXTENSION;
    }

    private static final String getDumpDirPath() {
        String petalsFileHandlerBaseDir = ExecutionContext.getProperties().getProperty("petalsFileHandlerBasedir");
        assert (petalsFileHandlerBaseDir != null && !petalsFileHandlerBaseDir.isEmpty()) : "'PetalsFileHandler.basedir must be defined";
        String logSubDir = ExecutionContext.getProperties().getProperty("logSubdir");
        assert (logSubDir != null);
        String dumpDir = petalsFileHandlerBaseDir + File.separator + logSubDir;
        return dumpDir;
    }
}

