/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.connection;

import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ow2.petals.cli.connection.AuthenticatedConnectionParameters;
import org.ow2.petals.cli.connection.ConnectionHelper;
import org.ow2.petals.cli.connection.ConnectionParameters;
import org.ow2.petals.cli.shell.command.exception.CommandException;

public class ConnectionHelperTest {
    private static final Options OPTIONS = new Options();
    private static final String CONFIRMATION_SHORT_OPTION = "y";
    private static HashMap<String, ConnectionParameters> preferenceConnectionParameters;
    private static ConnectionParameters connectionParameters1;
    private static ConnectionParameters defaultConnectionParameters;
    private static ConnectionParameters connectionParameters3;

    @BeforeClass
    public static void beforeClass() {
        preferenceConnectionParameters = new HashMap();
        connectionParameters1 = new ConnectionParameters("testHost1", 7845);
        preferenceConnectionParameters.put("aliasTest1", connectionParameters1);
        defaultConnectionParameters = new ConnectionParameters("testHost2", 4875);
        preferenceConnectionParameters.put("aliasTest2", defaultConnectionParameters);
        connectionParameters3 = new AuthenticatedConnectionParameters("testHost3", 4123, "testUser", "testPassword");
        preferenceConnectionParameters.put("aliasTest3", connectionParameters3);
    }

    @Test
    public final void testParseConnectionParametersWithNothingAndUseDefault() throws Exception {
        PosixParser parser = new PosixParser();
        String args = "connect";
        CommandLine cmd = parser.parse(OPTIONS, args.split(" "));
        ConnectionParameters connectionParameters = ConnectionHelper.parseConnectionParameters((CommandLine)cmd, (boolean)true, preferenceConnectionParameters, (ConnectionParameters)defaultConnectionParameters);
        Assert.assertEquals((Object)defaultConnectionParameters, (Object)connectionParameters);
    }

    @Test
    public final void testParseConnectionParametersWithNothingNotUseDefault() throws Exception {
        PosixParser parser = new PosixParser();
        String args = "connect";
        CommandLine cmd = parser.parse(OPTIONS, args.split(" "));
        ConnectionParameters connectionParameters = ConnectionHelper.parseConnectionParameters((CommandLine)cmd, (boolean)false, preferenceConnectionParameters, (ConnectionParameters)defaultConnectionParameters);
        Assert.assertNull((Object)connectionParameters);
    }

    @Test
    public final void testParseConnectionParametersWithAlias() throws Exception {
        PosixParser parser = new PosixParser();
        String args = "connect -a aliasTest3";
        CommandLine cmd = parser.parse(OPTIONS, args.split(" "));
        ConnectionParameters connectionParameters = ConnectionHelper.parseConnectionParameters((CommandLine)cmd, (boolean)true, preferenceConnectionParameters, (ConnectionParameters)defaultConnectionParameters);
        Assert.assertEquals((Object)connectionParameters3, (Object)connectionParameters);
    }

    @Test
    public final void testParseConnectionParametersWithParameters() throws Exception {
        PosixParser parser = new PosixParser();
        String args = "connect -h localhost -n 7700 -u testUser -p testPwd";
        CommandLine cmd = parser.parse(OPTIONS, args.split(" "));
        ConnectionParameters connectionParameters = ConnectionHelper.parseConnectionParameters((CommandLine)cmd, (boolean)true, preferenceConnectionParameters, (ConnectionParameters)defaultConnectionParameters);
        Assert.assertEquals((Object)new AuthenticatedConnectionParameters("localhost", 7700, "testUser", "testPwd"), (Object)connectionParameters);
    }

    @Test(expected=CommandException.class)
    public final void testParseConnectionParametersWithIncompatibleArguments() throws Exception {
        PosixParser parser = new PosixParser();
        String args = "connect -h localhost -n 7700 -u testUser -p testPwd -a aliasTest1";
        CommandLine cmd = parser.parse(OPTIONS, args.split(" "));
        try {
            ConnectionHelper.parseConnectionParameters((CommandLine)cmd, (boolean)true, preferenceConnectionParameters, (ConnectionParameters)defaultConnectionParameters);
        }
        catch (CommandException ce) {
            Assert.assertEquals((Object)"Bad number of arguments or incompatible arguments", (Object)ce.getMessage());
            throw ce;
        }
    }

    @Test(expected=CommandException.class)
    public final void testParseConnectionParametersWithBadNumberOfArguments() throws Exception {
        PosixParser parser = new PosixParser();
        String args = "connect -h localhost -n 7700";
        CommandLine cmd = parser.parse(OPTIONS, args.split(" "));
        try {
            ConnectionHelper.parseConnectionParameters((CommandLine)cmd, (boolean)true, preferenceConnectionParameters, (ConnectionParameters)defaultConnectionParameters);
        }
        catch (CommandException ce) {
            Assert.assertEquals((Object)"Bad number of arguments or incompatible arguments", (Object)ce.getMessage());
            throw ce;
        }
    }

    static {
        ConnectionHelper.addConnectionOptions((Options)OPTIONS);
        OptionBuilder.hasArg((boolean)false);
        OPTIONS.addOption(OptionBuilder.create((String)CONFIRMATION_SHORT_OPTION));
    }
}

