/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell;

import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.exception.DuplicatedCommandException;
import org.ow2.petals.cli.shell.exception.ShellException;

public class ShellTest {
    private TestShell shell;

    @Before
    public void setUp() throws Exception {
        this.shell = new TestShell();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testIsComment() {
        Assert.assertTrue((boolean)this.shell.isComment("#   "));
        Assert.assertTrue((boolean)this.shell.isComment(""));
        Assert.assertTrue((boolean)this.shell.isComment("   "));
        Assert.assertTrue((boolean)this.shell.isComment("           "));
        Assert.assertTrue((boolean)this.shell.isComment("    #"));
        Assert.assertTrue((boolean)this.shell.isComment("    ## ### ## "));
        Assert.assertFalse((boolean)this.shell.isComment("joe"));
        Assert.assertFalse((boolean)this.shell.isComment("  joe# "));
        Assert.assertFalse((boolean)this.shell.isComment(".#"));
    }

    @Test
    public final void testInterpolate() {
        Assert.assertEquals((Object)"booo", (Object)this.shell.interpolate("booo"));
        Assert.assertEquals((Object)"   space   ", (Object)this.shell.interpolate("   space   "));
        System.clearProperty("var");
        System.clearProperty("var2");
        Assert.assertEquals((Object)"${var}", (Object)this.shell.interpolate("${var}"));
        Assert.assertEquals((Object)"${var} ${var}", (Object)this.shell.interpolate("${var} ${var}"));
        Assert.assertEquals((Object)"${var} ${var} ${var2}", (Object)this.shell.interpolate("${var} ${var} ${var2}"));
        System.setProperty("var", "value");
        Assert.assertEquals((Object)"value", (Object)this.shell.interpolate("${var}"));
        Assert.assertEquals((Object)" value ", (Object)this.shell.interpolate(" ${var} "));
        Assert.assertEquals((Object)" value value ", (Object)this.shell.interpolate(" ${var} ${var} "));
        Assert.assertEquals((Object)" value value ${var2} ", (Object)this.shell.interpolate(" ${var} ${var} ${var2} "));
        Assert.assertEquals((Object)"${var}", (Object)this.shell.interpolate("\\${var}"));
        Assert.assertEquals((Object)" ${var} value \\${var} ", (Object)this.shell.interpolate(" \\${var} ${var} \\\\${var} "));
    }

    @Test
    public final void testRegister_Command() throws ShellException {
        TestCommand myCommand = new TestCommand();
        this.shell.register(myCommand);
        Map commands = this.shell.getCommands();
        Assert.assertNotNull((Object)commands);
        Assert.assertEquals((long)1L, (long)commands.size());
        Command registeredCommand = (Command)commands.get(myCommand.getName());
        Assert.assertNotNull((Object)registeredCommand);
    }

    @Test
    public final void testRegister_DuplicatedCommand() throws ShellException {
        TestCommand myCommand = new TestCommand();
        this.shell.register(myCommand);
        Map commands = this.shell.getCommands();
        Assert.assertNotNull((Object)commands);
        Assert.assertEquals((long)1L, (long)commands.size());
        try {
            this.shell.register(myCommand);
            Assert.fail((String)("The expected exception '" + DuplicatedCommandException.class.getName() + "' has not be thrown."));
        }
        catch (DuplicatedCommandException e) {
            Assert.assertEquals((Object)e.getCommandName(), (Object)myCommand.getName());
        }
    }

    private class TestCommand
    extends Command {
        private TestCommand() {
        }

        public void execute(String[] args) throws CommandException {
        }
    }

    private class TestShell
    extends Shell {
        public TestShell() throws ShellException {
            super(System.out, System.err);
        }

        public boolean isComment(String line) {
            return super.isComment(line);
        }

        public void run() throws ShellException {
        }
    }
}

