/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.net.URL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.ow2.petals.admin.AdminFactoryMock;
import org.ow2.petals.admin.ArtifactLifecycleFactoryMock;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;

public class AbstractArtifactCommandTest {
    protected URL componentURL = Thread.currentThread().getContextClassLoader().getResource("jbi-component-soap.zip");
    protected URL saURL = Thread.currentThread().getContextClassLoader().getResource("sa-permission.zip");
    protected URL saSoapidURL = Thread.currentThread().getContextClassLoader().getResource("sa-soapid.zip");
    protected URL slURL = Thread.currentThread().getContextClassLoader().getResource("petals-sl-mysql-5.1.5.zip");

    @Before
    public void beforeTest() {
        System.setProperty("org.ow2.petals.admin.api.factory", AdminFactoryMock.class.getName());
        System.setProperty("org.ow2.petals.admin.api.artifact.lifecycle.factory", ArtifactLifecycleFactoryMock.class.getName());
    }

    protected void deployStartArtifact(URL ... urls) throws ArtifactAdministrationException {
        ArtifactAdministration artifactAdministration = AdminFactory.newInstance().createArtifactAdministration();
        for (URL url : urls) {
            artifactAdministration.deployAndStartArtifact(url);
        }
    }

    @After
    public void afterTest() throws ArtifactAdministrationException {
        AdminFactory.newInstance().createArtifactAdministration().stopAndUndeployAllArtifacts();
        Assert.assertEquals((long)0L, (long)AdminFactory.newInstance().createArtifactAdministration().listArtifacts().size());
    }
}

