/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.cli.shell.command.AbstractArtifactCommandTest;
import org.ow2.petals.cli.shell.command.DummyShellWrapper;
import org.ow2.petals.cli.shell.command.LoggerSet;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandInvalidArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingOptionsException;

public class LoggerSetTest
extends AbstractArtifactCommandTest {
    @Test
    public void testArgumentsError_0() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        LoggerSet command = new LoggerSet(dummyShell.getShell());
        try {
            command.execute(new String[0]);
        }
        catch (CommandMissingOptionsException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Missing option(s)"));
            Assert.assertTrue((String)"The option '-n' shoul be missing.", (boolean)e.getMissingOptions().contains("n"));
            Assert.assertTrue((String)"The option '-l' shoul be missing.", (boolean)e.getMissingOptions().contains("l"));
            Assert.assertTrue((String)"Missing options are missing in error message.", (boolean)e.getMessage().endsWith(LoggerSetTest.convertOptions2String(e.getMissingOptions())));
        }
    }

    @Test
    public void testArgumentsError_1() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        LoggerSet command = new LoggerSet(dummyShell.getShell());
        try {
            command.execute(new String[]{"-n", "mylogger"});
        }
        catch (CommandMissingOptionsException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Missing option(s)"));
            Assert.assertTrue((String)"The option '-l' shoul be missing.", (boolean)e.getMissingOptions().contains("l"));
            Assert.assertTrue((String)"Missing options are missing in error message.", (boolean)e.getMessage().endsWith(LoggerSetTest.convertOptions2String(e.getMissingOptions())));
        }
    }

    @Test
    public void testArgumentsError_2() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        LoggerSet command = new LoggerSet(dummyShell.getShell());
        try {
            command.execute(new String[]{"-l", "INFO"});
        }
        catch (CommandMissingOptionsException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Missing option(s)"));
            Assert.assertTrue((String)"The option '-n' shoul be missing.", (boolean)e.getMissingOptions().contains("n"));
            Assert.assertTrue((String)"Missing options are missing in error message.", (boolean)e.getMessage().endsWith(LoggerSetTest.convertOptions2String(e.getMissingOptions())));
        }
    }

    @Test
    public void testArgumentsError_3() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        LoggerSet command = new LoggerSet(dummyShell.getShell());
        try {
            command.execute(new String[]{"-n", "-l", "INFO"});
        }
        catch (CommandMissingArgumentException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Missing argument"));
            Assert.assertTrue((String)"The option '-n' has a missing argument.", (boolean)"n".equals(e.getOption().getOpt()));
            Assert.assertTrue((String)"Missing argument is missing in error message.", (boolean)e.getMessage().endsWith("n"));
        }
    }

    @Test
    public void testArgumentsError_4() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        LoggerSet command = new LoggerSet(dummyShell.getShell());
        try {
            command.execute(new String[]{"-n", "mylogger", "-l"});
        }
        catch (CommandMissingArgumentException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Missing argument"));
            Assert.assertTrue((String)"The option '-l' has a missing argument.", (boolean)"l".equals(e.getOption().getOpt()));
            Assert.assertTrue((String)"Missing argument is missing in error message.", (boolean)e.getMessage().endsWith("l"));
        }
    }

    @Test
    public void testArgumentsError_5() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        LoggerSet command = new LoggerSet(dummyShell.getShell());
        try {
            command.execute(new String[]{"-n", "mylogger", "-l", "INVALID_LEVEL"});
            Assert.fail((String)"CommandInvalidArgumentException is not thrown through CommandException.");
        }
        catch (CommandInvalidArgumentException e) {
            Assert.assertEquals((String)"The invalid argument is not relative to the option '-l'", (Object)"l", (Object)e.getOption().getOpt());
            Assert.assertEquals((String)"The invalid value is not the expected one", (Object)"INVALID_LEVEL", (Object)e.getValue());
        }
    }

    @Test
    public void testArgumentsError_6() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        LoggerSet command = new LoggerSet(dummyShell.getShell());
        try {
            command.execute(new String[]{"-n", "invalid.logger", "-l", "INFO"});
            Assert.fail((String)"CommandInvalidArgumentException is not thrown through CommandException.");
        }
        catch (CommandInvalidArgumentException e) {
            Assert.assertEquals((String)"The invalid argument is not relative to the option '-n'", (Object)"n", (Object)e.getOption().getOpt());
            Assert.assertEquals((String)"The invalid value is not the expected one", (Object)"invalid.logger", (Object)e.getValue());
        }
    }

    @Test
    public void testArgumentsError_7() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        LoggerSet command = new LoggerSet(dummyShell.getShell());
        try {
            command.execute(new String[]{"-z"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"Command usage is missing.", (boolean)e.getMessage().endsWith(command.getUsage()));
        }
    }

    private static final String convertOptions2String(List missingOptions) {
        StringBuffer message = new StringBuffer();
        Iterator itMissingOptions = missingOptions.iterator();
        while (itMissingOptions.hasNext()) {
            message.append(itMissingOptions.next());
            if (!itMissingOptions.hasNext()) continue;
            message.append(", ");
        }
        return message.toString();
    }
}

