/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.admin.api.exception.ArtifactNotFoundException;
import org.ow2.petals.admin.api.exception.ArtifactTypeIsNeededException;
import org.ow2.petals.cli.shell.command.AbstractArtifactCommandTest;
import org.ow2.petals.cli.shell.command.DummyShellWrapper;
import org.ow2.petals.cli.shell.command.Undeploy;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.exception.ShellException;

public class UndeployTest
extends AbstractArtifactCommandTest {
    @Test
    public void testArgumentsError_0() throws CommandException {
        DummyShellWrapper dummyShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dummyShell.getShell());
        try {
            command.execute(new String[]{"-z"});
            Assert.fail((String)"CommandBadArgumentNumberException is not thrown");
        }
        catch (CommandBadArgumentNumberException e) {
            Assert.assertTrue((String)"Error label is missing.", (boolean)e.getMessage().startsWith("Bad number of arguments or incompatible arguments"));
            Assert.assertTrue((String)"Command usage is missing.", (boolean)e.getMessage().endsWith(command.getUsage()));
        }
    }

    @Test
    public void testUndeployAllArtifacts() throws ShellException, CommandException, ArtifactAdministrationException {
        this.deployStartArtifact(this.componentURL, this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        command.execute(new String[]{"--bulk"});
        Assert.assertEquals((long)0L, (long)AdminFactory.newInstance().createArtifactAdministration().listArtifacts().size());
    }

    @Test
    public void testUndeployOneArtifactsByURL() throws ShellException, ArtifactAdministrationException, CommandException {
        this.deployStartArtifact(this.componentURL, this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        command.execute(new String[]{"--url", this.saURL.toString()});
        List artifacts = AdminFactory.newInstance().createArtifactAdministration().listArtifacts();
        Assert.assertEquals((long)1L, (long)artifacts.size());
        Assert.assertTrue((boolean)(artifacts.get(0) instanceof Component));
    }

    @Test
    public void testUndeployOneArtifactsByTypeAndName_0() throws ShellException, ArtifactAdministrationException, CommandException {
        this.deployStartArtifact(this.componentURL, this.saURL);
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        Artifact a = admin.getArtifactInfo(this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        command.execute(new String[]{"--artifact", a.getName(), a.getType()});
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((long)1L, (long)artifacts.size());
        Assert.assertTrue((boolean)(artifacts.get(0) instanceof Component));
    }

    @Test
    public void testUndeployOneArtifactsByTypeAndName_1() throws ShellException, ArtifactAdministrationException, CommandException {
        this.deployStartArtifact(this.componentURL, this.saURL);
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        Artifact a = admin.getArtifactInfo(this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        command.execute(new String[]{"--artifact", a.getName()});
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((long)1L, (long)artifacts.size());
        Assert.assertTrue((boolean)(artifacts.get(0) instanceof Component));
    }

    @Test
    public void testUndeployOneArtifactsByTypeAndName_2() throws ShellException, ArtifactAdministrationException {
        this.deployStartArtifact(this.componentURL, this.saURL, this.saSoapidURL);
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        Artifact a = admin.getArtifactInfo(this.componentURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        try {
            command.execute(new String[]{"-a", a.getName()});
            Assert.fail((String)"ArtifactTypeIsNeededException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactTypeIsNeededException", (boolean)(e.getCause() instanceof ArtifactTypeIsNeededException));
        }
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((long)3L, (long)artifacts.size());
    }

    @Test
    public void testUndeployOneArtifactsByTypeAndName_3() throws ShellException, ArtifactAdministrationException, CommandException {
        this.deployStartArtifact(this.componentURL, this.saSoapidURL);
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        Artifact a = admin.getArtifactInfo(this.saSoapidURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        command.execute(new String[]{"-a", a.getName(), a.getType()});
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((long)1L, (long)artifacts.size());
        Assert.assertTrue((boolean)(artifacts.get(0) instanceof Component));
    }

    @Test
    public void testUndeployOneArtifactsByTypeAndName_4() throws ShellException, ArtifactAdministrationException, CommandException {
        this.deployStartArtifact(this.componentURL, this.saSoapidURL);
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        Artifact a = admin.getArtifactInfo(this.saSoapidURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        try {
            command.execute(new String[]{"-a", a.getType()});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((long)2L, (long)artifacts.size());
    }

    @Test
    public void testUndeployOneArtifactsByTypeAndName_5() throws ShellException, ArtifactAdministrationException, CommandException {
        this.deployStartArtifact(this.componentURL, this.saSoapidURL);
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        Artifact a = admin.getArtifactInfo(this.saSoapidURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        try {
            Assert.assertFalse((String)"The artifact is a SE", (boolean)"SE".equals(a.getType()));
            command.execute(new String[]{"-a", a.getName(), "SE"});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((long)2L, (long)artifacts.size());
    }

    @Test
    public void testUndeployOneArtifactsByTypeAndName_6() throws ShellException, ArtifactAdministrationException {
        this.deployStartArtifact(this.componentURL, this.saURL);
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        Artifact a = admin.getArtifactInfo(this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        try {
            Assert.assertFalse((String)"The artifact is a SE", (boolean)"SE".equals(a.getType()));
            command.execute(new String[]{"-a", a.getName(), "SE"});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((long)2L, (long)artifacts.size());
    }

    @Test
    public void testUndeployOneArtifactsByTypeAndName_7() throws ShellException, ArtifactAdministrationException {
        this.deployStartArtifact(this.componentURL, this.saURL);
        ArtifactAdministration admin = AdminFactory.newInstance().createArtifactAdministration();
        Artifact a = admin.getArtifactInfo(this.saURL);
        DummyShellWrapper dShell = new DummyShellWrapper();
        Undeploy command = new Undeploy(dShell.getShell());
        try {
            command.execute(new String[]{"-a", a.getType()});
            Assert.fail((String)"ArtifactNotFoundException is not thrown through CommandException.");
        }
        catch (CommandException e) {
            Assert.assertNotNull((String)"CommandException cause is missing.", (Object)e.getCause());
            Assert.assertTrue((String)"CommandException cause is not ArtifactNotFoundException", (boolean)(e.getCause() instanceof ArtifactNotFoundException));
        }
        List artifacts = admin.listArtifacts();
        Assert.assertEquals((long)2L, (long)artifacts.size());
    }
}

