/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ContainerAdministration;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;

public class Disconnect
extends Command {
    public Disconnect(Shell shell) {
        super(shell);
        this.setUsage("");
        this.setDescription("Disconnect from a petals container");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        if (!this.checkArguments(args, 0, 0)) {
            throw new CommandTooManyArgumentsException(this);
        }
        try {
            ContainerAdministration containerAdministration = AdminFactory.newInstance().createContainerAdministration();
            containerAdministration.disconnect();
            if (this.getShell() instanceof PetalsInteractiveCli) {
                String prompt = "petals-cli>";
                ((PetalsInteractiveCli)this.getShell()).updatePrompt(prompt);
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

