/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.util.Map;
import java.util.Properties;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ContainerAdministration;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;

public class PropertiesList
extends Command {
    public PropertiesList(Shell shell) {
        super(shell, "properties-list");
        this.setUsage("");
        this.setDescription("Get the values defined in its server.properties file");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        if (!this.checkArguments(args, 0, 0)) {
            throw new CommandTooManyArgumentsException(this);
        }
        try {
            ContainerAdministration containerAdministration = AdminFactory.newInstance().createContainerAdministration();
            Properties serverProperties = containerAdministration.getServerProperties();
            for (Map.Entry<Object, Object> property : serverProperties.entrySet()) {
                String key = (String)property.getKey();
                String value = (String)property.getValue();
                this.getShell().getPrintStream().println(String.format("%s: %s", key, value.isEmpty() ? "\"\"" : value));
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

