/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.exception.EndpointRegistryServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.EndpointRegistryServiceErrorException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;

public class EndpointRegistryClient
extends AbstractServiceClient {
    protected static final String GET_ALL_INTERNAL_ENDPOINTS = "getAllInternalEndpoints";
    protected static final String GET_ALL_EXTERNAL_ENDPOINTS = "getAllExternalEndpoints";
    protected static final String GET_ALL_ENDPOINTS = "getAllEndpoints";
    protected static final String GET_ENDPOINT_DESCRIPTION = "getDescription";
    public static final String SYNCHONIZE_REGISTRY = "synchronizeRegistry";
    private static final String ENDPOINT_SERVICE_JMX_NAME = "EndpointRegistry";

    public EndpointRegistryClient(String petalsDomain, MBeanServerConnection beanServerConnection) throws EndpointRegistryServiceDoesNotExistException, EndpointRegistryServiceErrorException {
        super(petalsDomain, beanServerConnection);
        try {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put("name", ENDPOINT_SERVICE_JMX_NAME);
            attributes.put("type", "service");
            ObjectName objName = new ObjectName(petalsDomain, attributes);
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            if (objNames == null || objNames.size() != 1) {
                throw new EndpointRegistryServiceDoesNotExistException();
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (MalformedObjectNameException e) {
            throw new EndpointRegistryServiceErrorException(e);
        }
        catch (IOException e) {
            throw new EndpointRegistryServiceErrorException(e);
        }
    }

    public List<Map<String, Object>> getAllInternalEndpoints() throws EndpointRegistryServiceErrorException {
        List endpoints;
        try {
            endpoints = (List)this.performAction(GET_ALL_INTERNAL_ENDPOINTS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new EndpointRegistryServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new EndpointRegistryServiceErrorException("Unexpected result type");
        }
        return endpoints;
    }

    public List<Map<String, Object>> getAllExternalEndpoints() throws EndpointRegistryServiceErrorException {
        List endpoints;
        try {
            endpoints = (List)this.performAction(GET_ALL_EXTERNAL_ENDPOINTS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new EndpointRegistryServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new EndpointRegistryServiceErrorException("Unexpected result type");
        }
        return endpoints;
    }

    public List<Map<String, Object>> getAllEndpoints() throws EndpointRegistryServiceErrorException {
        List endpoints;
        try {
            endpoints = (List)this.performAction(GET_ALL_ENDPOINTS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new EndpointRegistryServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new EndpointRegistryServiceErrorException("Unexpected result type");
        }
        return endpoints;
    }

    public String getDescription(String serviceName, String endpointName) throws EndpointRegistryServiceErrorException {
        String document;
        Object[] objects = new Object[]{serviceName, endpointName};
        String[] strings = new String[]{String.class.getName(), String.class.getName()};
        try {
            document = (String)this.performAction(GET_ENDPOINT_DESCRIPTION, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new EndpointRegistryServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new EndpointRegistryServiceErrorException("Unexpected result type");
        }
        return document;
    }

    public void synchronizeRegistry() throws PetalsAdminServiceErrorException {
        try {
            this.performAction(SYNCHONIZE_REGISTRY, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new PetalsAdminServiceErrorException(e);
        }
    }
}

