/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.InstallerComponentClient;
import org.ow2.petals.jmx.exception.InstallationServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.InstallationServiceErrorException;
import org.ow2.petals.jmx.exception.InstallerComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;

public final class InstallationServiceClient
extends AbstractServiceClient {
    private static final String FORCE_UNLOAD_INSTALLER = "forceUnloadInstaller";
    private static final String GET_COMPONENTS_FOR_SL = "getInstalledComponentsForSharedLibrary";
    private static final String GET_INSTALLED_SLS = "getInstalledSharedLibraries";
    private static final String GET_INSTALLERS = "getInstallers";
    private static final String INSTALL_SL = "installSharedLibrary";
    private static final String INSTALLATION_SERVICE_JMX_NAME = "Installation";
    private static final String LOAD_INSTALLER = "loadInstaller";
    private static final String LOAD_NEW_INSTALLER = "loadNewInstaller";
    private static final String SHUTDOWN_ALL_COMPONENTS = "shutdownAllComponents";
    private static final String SHUTDOWN_COMPONENT = "shutdownComponent";
    private static final String START_ALL_COMPONENTS = "startAllComponents";
    private static final String START_COMPONENT = "startComponent";
    private static final String STOP_ALL_COMPONENTS = "stopAllComponents";
    private static final String STOP_COMPONENT = "stopComponent";
    private static final String UNINSTALL_ALL_COMPONENTS = "uninstallAllComponents";
    private static final String UNINSTALL_ALL_SL = "uninstallAllSharedLibraries";
    private static final String UNINSTALL_SL = "uninstallSharedLibrary";
    private static final String UNLOAD_ALL_INSTALLERS = "unloadAllInstallers";
    private static final String UNLOAD_INSTALLER = "unloadInstaller";

    public InstallationServiceClient(String petalsDomain, MBeanServerConnection mBeanServerConnection) throws InstallationServiceDoesNotExistException, InstallationServiceErrorException {
        super(petalsDomain, mBeanServerConnection);
        try {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put("name", INSTALLATION_SERVICE_JMX_NAME);
            attributes.put("type", "service");
            ObjectName objName = new ObjectName(petalsDomain, attributes);
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            if (objNames == null || objNames.size() != 1) {
                throw new InstallationServiceDoesNotExistException();
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (MalformedObjectNameException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (IOException e) {
            throw new InstallationServiceErrorException(e);
        }
    }

    public boolean forceUnloadInstaller(String componentName) throws InstallationServiceErrorException {
        Boolean result;
        Object[] objects = new Object[]{componentName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (Boolean)this.performAction(FORCE_UNLOAD_INSTALLER, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] getInstalledComponentsForSharedlibrary(String sharedLibraryName) throws InstallationServiceErrorException {
        String[] slNames;
        Object[] objects = new Object[]{sharedLibraryName};
        String[] strings = new String[]{String.class.getName()};
        try {
            slNames = (String[])this.performAction(GET_COMPONENTS_FOR_SL, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return slNames;
    }

    public String[] getInstalledSharedLibraries() throws InstallationServiceErrorException {
        String[] slNames;
        try {
            slNames = (String[])this.performAction(GET_INSTALLED_SLS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return slNames;
    }

    public String[] getInstallers() throws InstallationServiceErrorException {
        String[] installerNames;
        try {
            installerNames = (String[])this.performAction(GET_INSTALLERS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return installerNames;
    }

    public String installSharedLibrary(URL sharedLibraryURL) throws InstallationServiceErrorException {
        String slName;
        Object[] objects = new Object[]{sharedLibraryURL.toString()};
        String[] strings = new String[]{String.class.getName()};
        try {
            slName = (String)this.performAction(INSTALL_SL, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return slName;
    }

    public InstallerComponentClient loadInstaller(String componentName) throws InstallerComponentDoesNotExistException, InstallationServiceErrorException {
        Object[] objects = new Object[]{componentName};
        String[] strings = new String[]{String.class.getName()};
        try {
            ObjectName installerName = (ObjectName)this.performAction(LOAD_INSTALLER, objects, strings);
            if (installerName == null) {
                throw new InstallerComponentDoesNotExistException(componentName);
            }
            return new InstallerComponentClient(this.petalsDomain, installerName, this.mBeanServerConnection);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
    }

    public InstallerComponentClient loadNewInstaller(URL packageURL) throws InstallationServiceErrorException {
        ObjectName installerName;
        Object[] objects = new Object[]{packageURL.toString()};
        String[] strings = new String[]{String.class.getName()};
        try {
            installerName = (ObjectName)this.performAction(LOAD_NEW_INSTALLER, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return new InstallerComponentClient(this.petalsDomain, installerName, this.mBeanServerConnection);
    }

    public String[] shutdownAllComponents() throws InstallationServiceErrorException {
        String[] componentNames;
        try {
            componentNames = (String[])this.performAction(SHUTDOWN_ALL_COMPONENTS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return componentNames;
    }

    public boolean shutdownComponent(String componentName) throws InstallationServiceErrorException {
        Boolean result;
        Object[] objects = new Object[]{componentName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (Boolean)this.performAction(SHUTDOWN_COMPONENT, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] startAllComponents() throws InstallationServiceErrorException {
        String[] componentNames;
        try {
            componentNames = (String[])this.performAction(START_ALL_COMPONENTS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return componentNames;
    }

    public boolean startComponent(String componentName) throws InstallationServiceErrorException {
        Boolean result;
        Object[] objects = new Object[]{componentName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (Boolean)this.performAction(START_COMPONENT, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] stopAllComponents() throws InstallationServiceErrorException {
        String[] componentNames;
        try {
            componentNames = (String[])this.performAction(STOP_ALL_COMPONENTS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return componentNames;
    }

    public boolean stopComponent(String componentName) throws InstallationServiceErrorException {
        Boolean result;
        Object[] objects = new Object[]{componentName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (Boolean)this.performAction(STOP_COMPONENT, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] uninstallAllComponents() throws InstallationServiceErrorException {
        String[] componentNames;
        try {
            componentNames = (String[])this.performAction(UNINSTALL_ALL_COMPONENTS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return componentNames;
    }

    public String[] uninstallAllSharedLibrary() throws InstallationServiceErrorException {
        String[] slNames;
        try {
            slNames = (String[])this.performAction(UNINSTALL_ALL_SL, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return slNames;
    }

    public boolean uninstallSharedLibrary(String sharedLibraryName) throws InstallationServiceErrorException {
        Boolean result;
        Object[] objects = new Object[]{sharedLibraryName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (Boolean)this.performAction(UNINSTALL_SL, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] unloadAllInstallers(boolean force) throws InstallationServiceErrorException {
        String[] componentNames;
        Object[] objects = new Object[]{force};
        String[] strings = new String[]{Boolean.TYPE.getName()};
        try {
            componentNames = (String[])this.performAction(UNLOAD_ALL_INSTALLERS, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return componentNames;
    }

    public boolean unloadInstaller(String componentName) throws InstallationServiceErrorException {
        Boolean result;
        Object[] objects = new Object[]{componentName, true};
        String[] strings = new String[]{String.class.getName(), Boolean.TYPE.getName()};
        try {
            result = (Boolean)this.performAction(UNLOAD_INSTALLER, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new InstallationServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new InstallationServiceErrorException("Unexpected result type");
        }
        return result;
    }
}

