/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.jmx;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.ow2.petals.admin.api.ContainerAdministration;
import org.ow2.petals.admin.api.artifact.Logger;
import org.ow2.petals.admin.api.exception.ContainerAdministrationException;
import org.ow2.petals.admin.api.exception.InvalidLogLevelException;
import org.ow2.petals.admin.api.exception.LoggerNotFoundException;
import org.ow2.petals.admin.jmx.JMXClientConnection;
import org.ow2.petals.admin.jmx.topology.TopologyUtils;
import org.ow2.petals.admin.topology.Domain;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.AdminDoesNotExistException;
import org.ow2.petals.jmx.exception.AdminServiceErrorException;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.LoggerDoesNotExistException;
import org.ow2.petals.jmx.exception.LoggerServiceErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminDoesNotExistException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;

public class JMXContainerAdministration
implements ContainerAdministration {
    protected JMXContainerAdministration() {
    }

    public void connect(String host, int port, String user, String password) throws ContainerAdministrationException {
        try {
            JMXClientConnection.createJMXClient(host, port, user, password);
        }
        catch (ConnectionErrorException cee) {
            throw new ContainerAdministrationException((Throwable)cee);
        }
    }

    public void disconnect() throws ContainerAdministrationException {
        try {
            JMXClientConnection.disconnectJMXClient();
        }
        catch (ConnectionErrorException cee) {
            throw new ContainerAdministrationException((Throwable)cee);
        }
    }

    public String getSystemInfo() throws ContainerAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String systemInfo = client.getAdminServiceClient().getSystemInfo();
            return systemInfo;
        }
        catch (ConnectionErrorException cee) {
            throw new ContainerAdministrationException((Throwable)cee);
        }
        catch (AdminServiceErrorException asee) {
            throw new ContainerAdministrationException((Throwable)asee);
        }
        catch (AdminDoesNotExistException adnee) {
            throw new ContainerAdministrationException((Throwable)adnee);
        }
    }

    public void stopContainer() throws ContainerAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            client.getPetalsAdminServiceClient().stopContainer();
            JMXClientConnection.disconnectJMXClient();
        }
        catch (ConnectionErrorException cee) {
            throw new ContainerAdministrationException((Throwable)cee);
        }
        catch (PetalsAdminServiceErrorException pasee) {
            throw new ContainerAdministrationException((Throwable)pasee);
        }
        catch (PetalsAdminDoesNotExistException padnee) {
            throw new ContainerAdministrationException((Throwable)padnee);
        }
    }

    public void shutdownContainer() throws ContainerAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            client.getPetalsAdminServiceClient().shutdownContainer();
            JMXClientConnection.disconnectJMXClient();
        }
        catch (ConnectionErrorException cee) {
            throw new ContainerAdministrationException((Throwable)cee);
        }
        catch (PetalsAdminServiceErrorException pasee) {
            throw new ContainerAdministrationException((Throwable)pasee);
        }
        catch (PetalsAdminDoesNotExistException padnee) {
            throw new ContainerAdministrationException((Throwable)padnee);
        }
    }

    public Domain getTopology() throws ContainerAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            Set topology = client.getPetalsAdminServiceClient().retrieveTopology();
            return TopologyUtils.createListOfDomains(topology);
        }
        catch (ConnectionErrorException cee) {
            throw new ContainerAdministrationException((Throwable)cee);
        }
        catch (PetalsAdminServiceErrorException pasee) {
            throw new ContainerAdministrationException((Throwable)pasee);
        }
        catch (PetalsAdminDoesNotExistException padnee) {
            throw new ContainerAdministrationException((Throwable)padnee);
        }
    }

    public Properties getServerProperties() throws ContainerAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            return client.getPetalsAdminServiceClient().retrieveServerProperties();
        }
        catch (ConnectionErrorException cee) {
            throw new ContainerAdministrationException((Throwable)cee);
        }
        catch (PetalsAdminServiceErrorException pasee) {
            throw new ContainerAdministrationException((Throwable)pasee);
        }
        catch (PetalsAdminDoesNotExistException padnee) {
            throw new ContainerAdministrationException((Throwable)padnee);
        }
    }

    public void changeLoggerLevel(String loggerName, String loggerLevel) throws LoggerNotFoundException, InvalidLogLevelException, ContainerAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            client.getLoggerServiceClient().setLevelForLogger(loggerName, loggerLevel);
        }
        catch (ConnectionErrorException cee) {
            throw new ContainerAdministrationException((Throwable)cee);
        }
        catch (LoggerServiceErrorException lsee) {
            throw new ContainerAdministrationException((Throwable)lsee);
        }
        catch (LoggerDoesNotExistException ldnee) {
            throw new ContainerAdministrationException((Throwable)ldnee);
        }
    }

    public List<Logger> getLoggers() throws ContainerAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            String[][] loggersArray = client.getLoggerServiceClient().getAllLoggers();
            LinkedList<Logger> loggers = new LinkedList<Logger>();
            for (int i = 0; i < loggersArray.length; ++i) {
                loggers.add(new Logger(loggersArray[i][0], loggersArray[i][1]));
            }
            return loggers;
        }
        catch (ConnectionErrorException cee) {
            throw new ContainerAdministrationException((Throwable)cee);
        }
        catch (LoggerServiceErrorException lsee) {
            throw new ContainerAdministrationException((Throwable)lsee);
        }
        catch (LoggerDoesNotExistException ldnee) {
            throw new ContainerAdministrationException((Throwable)ldnee);
        }
    }
}

