/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli;

import com.ebmwebsourcing.easycommons.lang.ExceptionHelper;
import java.io.FileInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.ow2.petals.cli.connection.ConnectionHelper;
import org.ow2.petals.cli.connection.ConnectionParameters;
import org.ow2.petals.cli.shell.PetalsCli;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;
import org.ow2.petals.cli.shell.PetalsScriptShell;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Connect;
import org.ow2.petals.cli.shell.command.Deploy;
import org.ow2.petals.cli.shell.command.Disconnect;
import org.ow2.petals.cli.shell.command.Exit;
import org.ow2.petals.cli.shell.command.Help;
import org.ow2.petals.cli.shell.command.ListArtifacts;
import org.ow2.petals.cli.shell.command.ListRegistry;
import org.ow2.petals.cli.shell.command.Load;
import org.ow2.petals.cli.shell.command.LoggerSet;
import org.ow2.petals.cli.shell.command.Loggers;
import org.ow2.petals.cli.shell.command.Print;
import org.ow2.petals.cli.shell.command.PropertiesList;
import org.ow2.petals.cli.shell.command.Pwd;
import org.ow2.petals.cli.shell.command.RegistrySync;
import org.ow2.petals.cli.shell.command.Set;
import org.ow2.petals.cli.shell.command.Show;
import org.ow2.petals.cli.shell.command.StartArtifact;
import org.ow2.petals.cli.shell.command.Stop;
import org.ow2.petals.cli.shell.command.StopArtifact;
import org.ow2.petals.cli.shell.command.SystemCall;
import org.ow2.petals.cli.shell.command.TopologyList;
import org.ow2.petals.cli.shell.command.Undeploy;
import org.ow2.petals.cli.shell.command.Version;

public class Main {
    private static final Options OPTIONS = new Options();
    private static final String USAGE_HEADER = "Petals JMX Command Line Interface\n";
    private static final String USAGE_USAGE;
    private static final String USAGE_FOOTER = "\nWhich evolution would you like on Petals? Share it! http://www.petalslink.com/feedback\n";
    private static final String HELP_SHORT_OPTION = "H";
    private static final String VERSION_SHORT_OPTION = "V";
    private static final String DEBUG_SHORT_OPTION = "d";
    private static final String COMMAND_SHORT_OPTION = "c";
    private static final String CONSOLE_SHORT_OPTION = "C";
    private static final String FILE_SHORT_OPTION;
    private static final String FILE_LONG_OPTION = "file";

    private static void printVersion() {
        StringBuffer sb = new StringBuffer();
        sb.append(USAGE_HEADER).append(' ');
        sb.append(Main.class.getPackage().getImplementationVersion()).append('\n');
        sb.append(System.getProperty("java.runtime.name")).append(' ');
        sb.append(System.getProperty("java.runtime.version")).append('\n');
        sb.append(System.getProperty("os.name")).append(' ');
        sb.append(System.getProperty("os.version")).append('\n');
        System.out.print(sb.toString());
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(USAGE_FOOTER.length());
        formatter.printHelp(USAGE_HEADER, USAGE_USAGE, OPTIONS, USAGE_FOOTER);
    }

    public static void main(String[] args) {
        block14: {
            PosixParser parser = new PosixParser();
            try {
                CommandLine cmd = parser.parse(OPTIONS, args);
                try {
                    Shell shell;
                    if (cmd.hasOption(VERSION_SHORT_OPTION)) {
                        Main.printVersion();
                        break block14;
                    }
                    if (cmd.hasOption(HELP_SHORT_OPTION)) {
                        Main.printUsage();
                        break block14;
                    }
                    if (cmd.hasOption(COMMAND_SHORT_OPTION)) {
                        shell = new PetalsCli(cmd.getOptionValues(COMMAND_SHORT_OPTION));
                    } else if (cmd.hasOption(CONSOLE_SHORT_OPTION)) {
                        shell = new PetalsInteractiveCli(cmd.hasOption(DEBUG_SHORT_OPTION));
                    } else {
                        String[] remainingArgs = cmd.getArgs();
                        if (remainingArgs.length > 0) {
                            String filename = remainingArgs[0];
                            shell = "-".equals(filename) ? new PetalsScriptShell(System.in, remainingArgs) : new PetalsScriptShell(new FileInputStream(filename), cmd.getArgs());
                        } else {
                            shell = null;
                            Main.printUsage();
                            System.exit(1);
                        }
                    }
                    ConnectionParameters connectionParameters = ConnectionHelper.parseConnectionParameters(cmd, false);
                    if (connectionParameters != null) {
                        ConnectionHelper.connect(connectionParameters, shell, false);
                    }
                    shell.register(new Connect(shell));
                    shell.register(new Disconnect(shell));
                    shell.register(new Exit(shell));
                    shell.register(new Help(shell));
                    shell.register(new Print(shell));
                    shell.register(new Load(shell));
                    shell.register(new Set(shell));
                    shell.register(new Pwd(shell));
                    shell.register(new ListArtifacts(shell));
                    shell.register(new ListRegistry(shell));
                    shell.register(new StartArtifact(shell));
                    shell.register(new StopArtifact(shell));
                    shell.register(new Deploy(shell));
                    shell.register(new Undeploy(shell));
                    shell.register(new Show(shell));
                    shell.register(new Version(shell));
                    shell.register(new Stop(shell));
                    shell.register(new SystemCall(shell));
                    shell.register(new Loggers(shell));
                    shell.register(new LoggerSet(shell));
                    shell.register(new PropertiesList(shell));
                    shell.register(new TopologyList(shell));
                    shell.register(new RegistrySync(shell));
                    shell.run();
                    System.exit(shell.getExitStatus());
                }
                catch (Exception e) {
                    System.err.println("ERROR: " + ExceptionHelper.getMessageFromRootCause((Throwable)e));
                    if (cmd.hasOption(DEBUG_SHORT_OPTION)) {
                        e.printStackTrace();
                    }
                    System.exit(1);
                }
            }
            catch (ParseException e) {
                System.err.println("ERROR: " + e.getMessage() + "\n");
                Main.printUsage();
                System.exit(1);
            }
        }
    }

    static {
        FILE_SHORT_OPTION = null;
        OPTIONS.addOption(DEBUG_SHORT_OPTION, "debug", false, "Print stack trace and debugging informations");
        ConnectionHelper.addConnectionOptions(OPTIONS);
        OptionGroup optionsGrp = new OptionGroup();
        OptionBuilder.withLongOpt("help");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Print this help message and exit.");
        optionsGrp.addOption(OptionBuilder.create(HELP_SHORT_OPTION));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Print the version number and exit.");
        optionsGrp.addOption(OptionBuilder.create(VERSION_SHORT_OPTION));
        OptionBuilder.withLongOpt("console");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Enable the mode 'console'.");
        optionsGrp.addOption(OptionBuilder.create(CONSOLE_SHORT_OPTION));
        OptionBuilder.withArgName("filename");
        OptionBuilder.withLongOpt(FILE_LONG_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Enable the script file execution. If filename is '-', commands are read from the stdin.");
        optionsGrp.addOption(OptionBuilder.create(FILE_SHORT_OPTION));
        OptionBuilder.withArgName("command");
        OptionBuilder.withLongOpt("command");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("Execute a command given on the command line.");
        optionsGrp.addOption(OptionBuilder.create(COMMAND_SHORT_OPTION));
        OPTIONS.addOptionGroup(optionsGrp);
        StringBuilder usage = new StringBuilder().append("[-").append(DEBUG_SHORT_OPTION).append("] ");
        ConnectionHelper.addConnectionUsage(usage, false);
        usage.append("[-").append(HELP_SHORT_OPTION).append(" | -").append(VERSION_SHORT_OPTION).append(" | [--").append(FILE_LONG_OPTION).append("] <filename> | -").append(COMMAND_SHORT_OPTION).append(" <command> | -").append(CONSOLE_SHORT_OPTION).append("]").toString();
        USAGE_USAGE = usage.toString();
    }
}

