/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell;

import com.ebmwebsourcing.easycommons.lang.ExceptionHelper;
import java.io.IOException;
import java.io.OutputStream;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.CommandCompleter;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.exception.ShellException;
import org.ow2.petals.cli.shell.exception.UnknownCommandException;

public class PetalsInteractiveCli
extends Shell {
    final ConsoleReader cr;
    private final boolean isDebugEnabled;

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public PetalsInteractiveCli(boolean debug) throws ShellException {
        super(System.out, System.err);
        this.isDebugEnabled = debug;
        try {
            this.cr = new ConsoleReader(System.in, (OutputStream)System.out, TerminalFactory.create());
            this.cr.setHistoryEnabled(true);
            this.cr.setExpandEvents(false);
            this.updatePrompt("petals-cli>");
        }
        catch (IOException e) {
            throw new ShellException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws ShellException {
        try {
            String line;
            CommandCompleter commandCompleter = new CommandCompleter(this.getCommands());
            this.cr.addCompleter((Completer)commandCompleter);
            while ((line = this.cr.readLine()) != null) {
                try {
                    this.evaluate(line);
                }
                catch (CommandException ce) {
                    this.printErrorMessage(ce, this.isDebugEnabled);
                }
                catch (UnknownCommandException uce) {
                    this.printErrorMessage(uce, this.isDebugEnabled);
                }
                finally {
                    this.cr.flush();
                }
            }
        }
        catch (IOException ioe) {
            throw new ShellException(ioe);
        }
    }

    protected void printErrorMessage(Throwable throwable, boolean debug) {
        this.errStream.println("ERROR: " + ExceptionHelper.getMessageFromRootCause((Throwable)throwable));
        if (debug) {
            throwable.printStackTrace(this.errStream);
        }
    }

    public void updatePrompt(String prompt) {
        this.cr.setPrompt(prompt);
    }

    public String askQuestion(String question, boolean password) throws IOException {
        this.cr.setHistoryEnabled(false);
        String prompt = this.cr.getPrompt();
        String response = password ? this.cr.readLine(question, new Character('*')) : this.cr.readLine(question);
        this.cr.setPrompt(prompt);
        this.cr.setHistoryEnabled(true);
        return response;
    }
}

