/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.exception.ShellException;
import org.ow2.petals.cli.shell.exception.UnknownCommandException;

public abstract class PetalsScript
extends Shell {
    private static final String STATUS_PROP_NAME = "status";
    private static final String STATUS_OK = "0";
    private static final String STATUS_KO = "1";
    private final InputStream incomingCommandStream;

    public PetalsScript(InputStream incomingCommandStream, PrintStream printStream, PrintStream errStream) throws ShellException {
        super(printStream, errStream);
        this.incomingCommandStream = incomingCommandStream;
    }

    protected abstract void onStart();

    protected abstract void onLine();

    protected abstract void onError(Exception var1, int var2) throws ShellException;

    @Override
    public void run() throws ShellException {
        this.onStart();
        if (this.incomingCommandStream != null) {
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.incomingCommandStream));
            block3: while (true) {
                try {
                    while (true) {
                        this.onLine();
                        String line = reader.readLine();
                        if (line == null) break block3;
                        this.evaluate(line);
                    }
                }
                catch (IOException ioe) {
                    throw new ShellException(ioe.getMessage());
                }
                catch (Exception e) {
                    this.onError(e, reader.getLineNumber());
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public void evaluate(String[] args) throws UnknownCommandException, CommandException {
        try {
            super.evaluate(args);
            System.setProperty(STATUS_PROP_NAME, STATUS_OK);
        }
        catch (CommandException e) {
            System.setProperty(STATUS_PROP_NAME, STATUS_KO);
            throw e;
        }
    }
}

