/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.petals.cli.shell.PetalsCli;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.exception.DuplicatedCommandException;
import org.ow2.petals.cli.shell.exception.ShellException;
import org.ow2.petals.cli.shell.exception.UnknownCommandException;
import org.ow2.petals.cli.shell.util.Utils;

public abstract class Shell {
    public static final Pattern REGEX_COMMENT = Pattern.compile("^\\s*(#.*)?$");
    public static final Pattern REGEX_VARIABLE = Pattern.compile("(\\\\|\\B)?(\\$\\{([-_\\.\\w]+)\\})");
    private Map<String, Command> commands = new HashMap<String, Command>();
    protected final PrintStream printStream;
    protected final PrintStream errStream;
    private int exitStatus = 0;

    public Shell(PrintStream printStream, PrintStream errStream) throws ShellException {
        this.printStream = printStream;
        this.errStream = errStream;
    }

    public final Map<String, Command> getCommands() {
        return this.commands;
    }

    public void register(Command command) throws DuplicatedCommandException, IllegalArgumentException {
        assert (command != null);
        String name = command.getName();
        if (this.commands.containsKey(name)) {
            throw new DuplicatedCommandException(name);
        }
        this.commands.put(name, command);
    }

    public abstract void run() throws ShellException;

    protected boolean isComment(String line) {
        return PetalsCli.REGEX_COMMENT.matcher(line).matches();
    }

    public String interpolate(String str) {
        Matcher m = REGEX_VARIABLE.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String backslash = m.group(1);
            String property = m.group(2).replace("$", "\\$");
            String name = m.group(3);
            String value = System.getProperty(name);
            if (value == null || backslash.length() > 0) {
                m.appendReplacement(sb, property);
                continue;
            }
            m.appendReplacement(sb, value);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public void exit(int status) {
        System.exit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluate(String[] args) throws UnknownCommandException, CommandException {
        assert (args != null && args.length > 0);
        String cmdName = args[0];
        if (!this.commands.containsKey(cmdName)) {
            throw new UnknownCommandException(cmdName);
        }
        Command cmd = this.commands.get(cmdName);
        String[] nargs = new String[args.length - 1];
        for (int i = 0; i < nargs.length; ++i) {
            nargs[i] = this.interpolate(args[i + 1]);
        }
        try {
            cmd.execute(nargs);
        }
        finally {
            cmd.reset();
        }
    }

    protected final void evaluate(String line) throws UnknownCommandException, CommandException {
        if (!this.isComment(line)) {
            String[] args = Utils.getLineArgs(line);
            this.evaluate(args);
        }
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
    }
}

