/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.ow2.petals.cli.shell.command.Command;

public class CommandCompleter
implements Completer {
    private Map<String, Command> commands;

    public CommandCompleter(Map<String, Command> commands) {
        this.commands = commands;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        String lineBegin = buffer.substring(0, cursor);
        int lastSpaceIndex = lineBegin.lastIndexOf(" ");
        if (lastSpaceIndex == -1) {
            String cmdName = lineBegin.substring(0, cursor);
            StringsCompleter cmdCompleter = new StringsCompleter(this.commands.keySet());
            int completionIndex = cmdCompleter.complete(cmdName, cursor, candidates);
            CommandCompleter.removeUselessSpace(buffer, cursor, candidates);
            return completionIndex;
        }
        if (lastSpaceIndex == cursor - 1) {
            return this.completeOptionOrArgument(buffer, cursor, candidates, lineBegin, lastSpaceIndex, "");
        }
        String lastWordToComplete = lineBegin.substring(lastSpaceIndex + 1, cursor);
        return this.completeOptionOrArgument(buffer, cursor, candidates, lineBegin, lastSpaceIndex, lastWordToComplete);
    }

    protected int completeOptionOrArgument(String buffer, int cursor, List<CharSequence> candidates, String lineBegin, int lastSpaceIndex, String lastWordToComplete) {
        int firstSpaceIndex = buffer.indexOf(" ");
        String cmdName = buffer.substring(0, firstSpaceIndex);
        if (this.commands.containsKey(cmdName)) {
            Command command = this.commands.get(cmdName);
            int optionArgNb = 0;
            int previousSpaceIndex = lastSpaceIndex;
            String previousWord = null;
            do {
                lineBegin = lineBegin.substring(0, previousSpaceIndex);
                ++optionArgNb;
                lastSpaceIndex = previousSpaceIndex;
                previousSpaceIndex = lineBegin.lastIndexOf(" ");
                if (previousSpaceIndex != -1) continue;
                return CommandCompleter.completeOptionPossibilityOrAgument(buffer, cursor, candidates, command, lastWordToComplete);
            } while (!(previousWord = lineBegin.substring(previousSpaceIndex + 1, lastSpaceIndex)).startsWith("-"));
            Options options = command.getOptions();
            if (options.hasOption(previousWord)) {
                Option option = options.getOption(previousWord);
                if (option.getArgs() >= optionArgNb) {
                    return CommandCompleter.completeOptionValue(buffer, cursor, candidates, command, option, lastSpaceIndex);
                }
                return CommandCompleter.completeOptionPossibilityOrAgument(buffer, cursor, candidates, command, lastWordToComplete);
            }
        }
        return -1;
    }

    protected static final int completeOptionValue(String buffer, int cursor, List<CharSequence> candidates, Command command, Option option, int lastSpaceIndex) {
        Completer completer = command.getOptionCompleters().get(option.getOpt());
        if (completer != null) {
            String expressionToComplete = buffer.substring(lastSpaceIndex + 1, cursor);
            int completionIndex = completer.complete(expressionToComplete, cursor, candidates);
            CommandCompleter.removeUselessSpace(buffer, cursor, candidates);
            return cursor - expressionToComplete.length() + completionIndex;
        }
        return -1;
    }

    private static final int completeOptionPossibilityOrAgument(String buffer, int cursor, List<CharSequence> candidates, Command command, String lastWordToComplete) {
        if (lastWordToComplete.startsWith("-")) {
            ArrayList<String> optionStrings = new ArrayList<String>();
            Options options = command.getOptions();
            for (Object optionObj : options.getOptions()) {
                String longOpt;
                Option option = (Option)optionObj;
                String shortOption = option.getOpt();
                if (shortOption != null) {
                    String opt = "-" + shortOption;
                    optionStrings.add(opt);
                }
                if ((longOpt = option.getLongOpt()) == null) continue;
                String opt = "--" + longOpt;
                optionStrings.add(opt);
            }
            StringsCompleter optionCompleter = new StringsCompleter(optionStrings);
            int completionIndex = optionCompleter.complete(lastWordToComplete, cursor, candidates);
            CommandCompleter.removeUselessSpace(buffer, cursor, candidates);
            return cursor - lastWordToComplete.length() + completionIndex;
        }
        Completer completer = command.getDefaultCompleter();
        if (completer != null) {
            int completionIndex = completer.complete(lastWordToComplete, cursor, candidates);
            CommandCompleter.removeUselessSpace(buffer, cursor, candidates);
            return cursor - lastWordToComplete.length() + completionIndex;
        }
        return -1;
    }

    private static final void removeUselessSpace(String buffer, int cursor, List<CharSequence> candidates) {
        if (cursor < buffer.length() && candidates.size() == 1 && buffer.charAt(cursor) == ' ') {
            CharSequence candidate = candidates.get(0);
            candidate = candidate.subSequence(0, candidate.length() - 1);
            candidates.set(0, candidate);
        }
    }
}

