/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import com.ebmwebsourcing.easycommons.lang.CollectionHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.completer.StringsCompleter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.ArtifactState;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.SharedLibrary;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.util.Utils;

public class ListArtifacts
extends Command {
    static final String TYPE_SHORT_OPTION = "t";
    static final String TYPE_LONG_OPTION = "type";
    private static final Option TYPE_OPTION;
    static final String REGEX_SHORT_OPTION = "p";
    static final String REGEX_LONG_OPTION = "pattern";
    private static final Option REGEX_OPTION;
    private final String separator = " ";
    final Comparator<Artifact> artifactNameComparator = new Comparator<Artifact>(){

        @Override
        public int compare(Artifact o1, Artifact o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private PosixParser clParser = new PosixParser();

    public ListArtifacts(Shell shell) {
        super(shell, "list");
        this.setUsage(Utils.formatOptionsUsage(this.getOptions(), this.getName()));
        this.setDescription("List JBI artifacts name and current status");
        this.setOptionsDescription(Utils.formatOptionsDescription(this.getOptions()));
        this.completers.put(TYPE_SHORT_OPTION, new StringsCompleter(new String[]{"SL", Component.ComponentType.BC.toString(), Component.ComponentType.SE.toString(), "SA", "SU"}));
    }

    @Override
    public void execute(String[] args) throws CommandException {
        try {
            ArrayList<CollectionHelper.Filter<Artifact>> filters = new ArrayList<CollectionHelper.Filter<Artifact>>();
            CommandLine cli = this.clParser.parse(this.getOptions(), args);
            if (cli.getArgs().length > 0) {
                throw new CommandBadArgumentNumberException(this);
            }
            if (cli.hasOption(TYPE_SHORT_OPTION)) {
                filters.add(new TypeFilter(cli.getOptionValue(TYPE_SHORT_OPTION)));
            }
            if (cli.hasOption(REGEX_SHORT_OPTION)) {
                filters.add(new RegexFilter(cli.getOptionValue(REGEX_SHORT_OPTION)));
            }
            ArtifactAdministration artifactAdministration = AdminFactory.newInstance().createArtifactAdministration();
            List artifacts = artifactAdministration.listArtifacts();
            StringBuilder out = new StringBuilder();
            for (Artifact artifact : this.sortArtifacts(artifacts, filters)) {
                out.append(artifact.getName());
                if (artifact instanceof ArtifactState) {
                    out.append(" ");
                    out.append(((ArtifactState)artifact).getState().toString());
                }
                out.append(" ");
                out.append(artifact.getType());
                out.append("\n");
            }
            if (!artifacts.isEmpty()) {
                this.getShell().getPrintStream().print(out);
            }
        }
        catch (UnrecognizedOptionException e) {
            throw new CommandBadArgumentNumberException(this);
        }
        catch (ArtifactAdministrationException e) {
            throw new CommandException(e);
        }
        catch (ParseException e) {
            throw new CommandException(e);
        }
    }

    private ArrayList<Artifact> sortArtifacts(List<Artifact> artifacts, List<CollectionHelper.Filter<Artifact>> filters) {
        TreeSet<Artifact> sls = new TreeSet<Artifact>(this.artifactNameComparator);
        TreeSet<Artifact> bcs = new TreeSet<Artifact>(this.artifactNameComparator);
        TreeSet<Artifact> ses = new TreeSet<Artifact>(this.artifactNameComparator);
        TreeSet<Artifact> sas = new TreeSet<Artifact>(this.artifactNameComparator);
        TreeSet<Artifact> sus = new TreeSet<Artifact>(this.artifactNameComparator);
        for (Artifact artifact : artifacts) {
            if (artifact instanceof SharedLibrary) {
                sls.add((Artifact)((SharedLibrary)artifact));
                continue;
            }
            if (Component.ComponentType.BC.toString().equals(artifact.getType())) {
                bcs.add((Artifact)((Component)artifact));
                continue;
            }
            if (Component.ComponentType.SE.toString().equals(artifact.getType())) {
                ses.add((Artifact)((Component)artifact));
                continue;
            }
            if (!(artifact instanceof ServiceAssembly)) continue;
            sas.add((Artifact)((ServiceAssembly)artifact));
            sus.addAll(((ServiceAssembly)artifact).getServiceUnits());
        }
        ArrayList<Artifact> sortedArtifacts = new ArrayList<Artifact>(sls);
        sortedArtifacts.addAll(bcs);
        sortedArtifacts.addAll(ses);
        sortedArtifacts.addAll(sas);
        sortedArtifacts.addAll(sus);
        if (filters != null && filters.size() > 0) {
            CollectionHelper.filter(sortedArtifacts, filters);
        }
        return sortedArtifacts;
    }

    @Override
    public Options createOptions() {
        Options options = new Options();
        options.addOption(TYPE_OPTION);
        options.addOption(REGEX_OPTION);
        return options;
    }

    static {
        OptionBuilder.isRequired(false);
        OptionBuilder.withLongOpt(TYPE_LONG_OPTION);
        OptionBuilder.withDescription("<artifact-type> is one of the following optional values: SL, BC, SE, SA, SU, used to restrict the returned list.");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("artifact-type");
        TYPE_OPTION = OptionBuilder.create(TYPE_SHORT_OPTION);
        OptionBuilder.isRequired(false);
        OptionBuilder.withLongOpt(REGEX_LONG_OPTION);
        OptionBuilder.withDescription("<artifact-pattern> is an optional RegExp pattern to filter the content of the returned list. All the returned JBI artifacts must have a JBI identifier matching the pattern.");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("artifact-pattern");
        REGEX_OPTION = OptionBuilder.create(REGEX_SHORT_OPTION);
    }

    private class RegexFilter
    implements CollectionHelper.Filter<Artifact> {
        private final Pattern pattern;

        public RegexFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public boolean accept(Artifact a) {
            Matcher m = this.pattern.matcher(a.getName());
            return m.matches();
        }
    }

    private class TypeFilter
    implements CollectionHelper.Filter<Artifact> {
        private final String type;

        public TypeFilter(String type) {
            this.type = type;
        }

        public boolean accept(Artifact a) {
            if (this.type == null) {
                return true;
            }
            return a.getType().equals(this.type);
        }
    }
}

