/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.RegistryAdministration;
import org.ow2.petals.admin.api.exception.RegistryAdministrationException;
import org.ow2.petals.admin.registry.Endpoint;
import org.ow2.petals.admin.registry.RegistryView;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingOptionsException;

public class ListRegistry
extends Command {
    private static final String DEFAULT_REGEX_OPTION_VALUE = ".*";
    private static final Options OPTIONS = new Options();
    private static final String ENDPOINT_NAME_SHORT_OPTION = "e";
    private static final String ENDPOINT_NAME_LONG_OPTION = "endpoint";
    private static final String ENDPOINT_NAME_ARG_NAME = "endpoint";
    private static final Option ENDPOINT_NAME_OPTION;
    private static final String SERVICE_NAME_SHORT_OPTION = "s";
    private static final String SERVICE_NAME_LONG_OPTION = "service";
    private static final String SERVICE_NAME_ARG_NAME = "service";
    private static final Option SERVICE_NAME_OPTION;
    private static final String INTERFACE_NAME_SHORT_OPTION = "i";
    private static final String INTERFACE_NAME_LONG_OPTION = "interface";
    private static final String INTERFACE_NAME_ARG_NAME = "interface";
    private static final Option INTERFACE_NAME_OPTION;

    public ListRegistry(Shell shell) {
        super(shell, "registry-list");
        this.setUsage("[-e <endpoint-name-regex>] [-s <service-name-regex>] [-i <interface-name-regex>]");
        this.setDescription("List the entries of the registry");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(this.getOptions(), args);
            String endpointNameRegex = ListRegistry.getRegexOption(cmd, ENDPOINT_NAME_SHORT_OPTION);
            String serviceNameRegex = ListRegistry.getRegexOption(cmd, SERVICE_NAME_SHORT_OPTION);
            String interfaceNameRegex = ListRegistry.getRegexOption(cmd, INTERFACE_NAME_SHORT_OPTION);
            RegistryAdministration registryAdministration = AdminFactory.newInstance().createRegistryAdministration();
            RegistryView registryView = registryAdministration.getRegistryContent(endpointNameRegex, serviceNameRegex, interfaceNameRegex);
            StringBuilder registryContent = new StringBuilder("Endpoints:\n");
            List endpoints = registryView.getAllEndpoints();
            for (Endpoint endpoint : endpoints) {
                String endpointInformation = String.format("%s: %s,%s,%s\n", endpoint.getEndpointName(), endpoint.getContainerName(), endpoint.getComponentName(), endpoint.getEndpointType());
                registryContent.append(endpointInformation);
            }
            registryContent.append("Services:\n");
            Map endpointsByServiceName = registryView.getListOfEndpointsByServiceName();
            for (String serviceName : endpointsByServiceName.keySet()) {
                registryContent.append(serviceName + ":\n");
                for (Endpoint endpoint : (List)endpointsByServiceName.get(serviceName)) {
                    registryContent.append(endpoint.getEndpointName() + " ");
                }
                registryContent.append("\n");
            }
            registryContent.append("Interfaces:\n");
            Map endpointsByInterfaceName = registryView.getListOfEndpointsByInterfaceName();
            for (String interfaceName : endpointsByInterfaceName.keySet()) {
                registryContent.append(interfaceName + ":\n");
                for (Endpoint endpoint : (List)endpointsByInterfaceName.get(interfaceName)) {
                    registryContent.append(endpoint.getEndpointName() + " ");
                }
                registryContent.append("\n");
            }
            PrintStream out = this.getShell().getPrintStream();
            out.println(registryContent);
        }
        catch (UnrecognizedOptionException e) {
            throw new CommandBadArgumentNumberException(this);
        }
        catch (MissingArgumentException e) {
            throw new CommandMissingArgumentException(e.getOption());
        }
        catch (MissingOptionException e) {
            throw new CommandMissingOptionsException(e.getMissingOptions());
        }
        catch (ParseException e) {
            throw new CommandException(e);
        }
        catch (RegistryAdministrationException e) {
            throw new CommandException(e);
        }
    }

    private static final String getRegexOption(CommandLine cmd, String option) {
        String endpointNameRegex = cmd.hasOption(option) ? cmd.getOptionValue(option) : DEFAULT_REGEX_OPTION_VALUE;
        return endpointNameRegex;
    }

    @Override
    public Options createOptions() {
        Options options = new Options();
        options.addOption(ENDPOINT_NAME_OPTION);
        options.addOption(SERVICE_NAME_OPTION);
        options.addOption(INTERFACE_NAME_OPTION);
        return options;
    }

    static {
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("endpoint");
        OptionBuilder.withLongOpt("endpoint");
        OptionBuilder.withDescription("Endpoint name regular expression.");
        ENDPOINT_NAME_OPTION = OptionBuilder.create(ENDPOINT_NAME_SHORT_OPTION);
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("service");
        OptionBuilder.withLongOpt("service");
        OptionBuilder.withDescription("Service name regular expression.");
        SERVICE_NAME_OPTION = OptionBuilder.create(SERVICE_NAME_SHORT_OPTION);
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("interface");
        OptionBuilder.withLongOpt("interface");
        OptionBuilder.withDescription("Interface name regular expression.");
        INTERFACE_NAME_OPTION = OptionBuilder.create(INTERFACE_NAME_SHORT_OPTION);
    }
}

