/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ContainerAdministration;
import org.ow2.petals.admin.api.artifact.Logger;
import org.ow2.petals.admin.api.exception.ContainerAdministrationException;
import org.ow2.petals.admin.api.exception.InvalidLogLevelException;
import org.ow2.petals.admin.api.exception.LoggerNotFoundException;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandInvalidArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingOptionsException;
import org.ow2.petals.cli.shell.util.Utils;

public class LoggerSet
extends Command {
    static final String LOGGER_NAME_SHORT_OPTION = "n";
    static final String LOGGER_NAME_LONG_OPTION = "logger";
    private static final Option LOGGER_NAME_OPTION;
    static final String LEVEL_SHORT_OPTION = "l";
    static final String LEVEL_LONG_OPTION = "level";
    private static final Option LEVEL_OPTION;
    static final String RESULT_SUCCEEDED = "The log level was succesfully updated.";
    private final CommandLineParser clParser = new PosixParser();

    public LoggerSet(Shell shell) {
        super(shell, "logger-set");
        this.setUsage(Utils.formatOptionsUsage(this.getOptions(), this.getName()));
        this.setDescription("Set the specified level to the specified logger");
        this.setOptionsDescription(Utils.formatOptionsDescription(this.getOptions()));
    }

    @Override
    public void execute(String[] args) throws CommandException {
        try {
            String loggerName;
            ContainerAdministration containerAdministration;
            String level;
            CommandLine cli = this.clParser.parse(this.getOptions(), args, false);
            if (cli.hasOption(LOGGER_NAME_SHORT_OPTION) && cli.hasOption(LEVEL_SHORT_OPTION)) {
                level = cli.getOptionValue(LEVEL_SHORT_OPTION);
                if (!("SEVERE".equals(level) || "WARNING".equals(level) || "INFO".equals(level) || "CONFIG".equals(level) || "MONIT".equals(level) || "FINE".equals(level) || "FINER".equals(level) || "FINEST".equals(level))) {
                    throw new InvalidLogLevelException(level);
                }
                containerAdministration = AdminFactory.newInstance().createContainerAdministration();
                loggerName = cli.getOptionValue(LOGGER_NAME_SHORT_OPTION);
                List loggers = containerAdministration.getLoggers();
                boolean found = false;
                for (Logger logger : loggers) {
                    if (!logger.getName().equals(loggerName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new LoggerNotFoundException(loggerName);
                }
            } else {
                throw new CommandBadArgumentNumberException(this);
            }
            containerAdministration.changeLoggerLevel(loggerName, level);
            this.getShell().getPrintStream().println(RESULT_SUCCEEDED);
        }
        catch (UnrecognizedOptionException e) {
            throw new CommandBadArgumentNumberException(this);
        }
        catch (MissingArgumentException e) {
            throw new CommandMissingArgumentException(e.getOption());
        }
        catch (MissingOptionException e) {
            throw new CommandMissingOptionsException(e.getMissingOptions());
        }
        catch (ParseException e) {
            throw new CommandException(e);
        }
        catch (InvalidLogLevelException e) {
            throw new CommandInvalidArgumentException(LEVEL_OPTION, e.getLevel());
        }
        catch (LoggerNotFoundException e) {
            throw new CommandInvalidArgumentException(LOGGER_NAME_OPTION, e.getLogger());
        }
        catch (ContainerAdministrationException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public Map<String, Completer> getOptionCompleters() {
        try {
            ContainerAdministration containerAdministration = AdminFactory.newInstance().createContainerAdministration();
            LinkedList<String> loggerNames = new LinkedList<String>();
            List loggers = containerAdministration.getLoggers();
            for (Logger logger : loggers) {
                loggerNames.add(logger.getName());
            }
            this.completers.put(LOGGER_NAME_SHORT_OPTION, new StringsCompleter(loggerNames));
        }
        catch (ContainerAdministrationException containerAdministrationException) {
            // empty catch block
        }
        this.completers.put(LEVEL_SHORT_OPTION, new StringsCompleter(new String[]{"SEVERE", "WARNING", "INFO", "CONFIG", "MONIT", "FINE", "FINER", "FINEST"}));
        return this.completers;
    }

    @Override
    public Options createOptions() {
        Options options = new Options();
        options.addOption(LOGGER_NAME_OPTION);
        options.addOption(LEVEL_OPTION);
        return options;
    }

    static {
        OptionBuilder.isRequired(true);
        OptionBuilder.withLongOpt(LOGGER_NAME_LONG_OPTION);
        OptionBuilder.withDescription("The logger name for which the level will be set.");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("logger-name");
        LOGGER_NAME_OPTION = OptionBuilder.create(LOGGER_NAME_SHORT_OPTION);
        OptionBuilder.isRequired(true);
        OptionBuilder.withLongOpt(LEVEL_LONG_OPTION);
        OptionBuilder.withDescription("The level to set to the logger name.");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("logger-level");
        LEVEL_OPTION = OptionBuilder.create(LEVEL_SHORT_OPTION);
    }
}

