/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandException;

public class SystemCall
extends Command {
    public SystemCall(Shell shell) {
        super(shell, "system");
        this.setUsage("\"systemcommand arg0 arg1\"");
        this.setDescription("Execute system command");
    }

    @Override
    public void execute(String[] args) throws CommandException {
        try {
            int c;
            Process process = Runtime.getRuntime().exec(args[0]);
            BufferedInputStream stdout = new BufferedInputStream(process.getInputStream());
            PrintStream ps = this.getShell().getPrintStream();
            while ((c = stdout.read()) != -1) {
                ps.write(c);
            }
            int exitCode = process.waitFor();
            this.getShell().setExitStatus(exitCode);
            stdout.close();
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        catch (InterruptedException e) {
            throw new CommandException(e);
        }
    }
}

