/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.cli.shell.command;

import java.net.MalformedURLException;
import java.util.Map;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.ow2.petals.admin.api.AdminFactory;
import org.ow2.petals.admin.api.ArtifactAdministration;
import org.ow2.petals.admin.api.exception.ArtifactAdministrationException;
import org.ow2.petals.cli.Constants;
import org.ow2.petals.cli.shell.PetalsInteractiveCli;
import org.ow2.petals.cli.shell.Shell;
import org.ow2.petals.cli.shell.command.Command;
import org.ow2.petals.cli.shell.command.exception.CommandBadArgumentNumberException;
import org.ow2.petals.cli.shell.command.exception.CommandException;
import org.ow2.petals.cli.shell.command.exception.CommandMissingArgumentException;
import org.ow2.petals.cli.shell.command.exception.CommandTooManyArgumentsException;
import org.ow2.petals.cli.shell.util.Utils;

public class Undeploy
extends Command {
    protected static final Option BULK_OPTION;
    private ArtifactAdministration artifactAdministration = AdminFactory.newInstance().createArtifactAdministration();

    public Undeploy(Shell shell) {
        super(shell);
        this.setUsage(Utils.formatOptionsUsage(this.getOptions(), this.getName()));
        this.setDescription("Stop and uninstall or undeploy JBI artifacts");
        this.setOptionsDescription(Utils.formatOptionsDescription(this.getOptions()));
        this.completers.put("u", new FileNameCompleter());
    }

    @Override
    public void execute(String[] args) throws CommandException {
        block15: {
            PosixParser parser = new PosixParser();
            try {
                CommandLine cl = parser.parse(this.getOptions(), args, true);
                if (cl.hasOption("b")) {
                    if (!this.checkArguments(args, 1, 1)) {
                        throw new CommandTooManyArgumentsException(this);
                    }
                    this.artifactAdministration.stopAndUndeployAllArtifacts();
                    break block15;
                }
                if (cl.hasOption("u")) {
                    if (!this.checkArguments(args, 2)) {
                        throw new CommandBadArgumentNumberException(this);
                    }
                    for (String arg : cl.getOptionValues("u")) {
                        this.artifactAdministration.stopAndUndeployArtifact(Utils.toURL(arg));
                    }
                    break block15;
                }
                if (cl.hasOption("a")) {
                    if (!this.checkArguments(args, 2, 3)) {
                        throw new CommandTooManyArgumentsException(this);
                    }
                    String[] values = cl.getOptionValues("a");
                    if (values.length == 1) {
                        this.artifactAdministration.stopAndUndeployArtifact(null, values[0]);
                    } else {
                        this.artifactAdministration.stopAndUndeployArtifact(values[1], values[0]);
                    }
                    break block15;
                }
                throw new CommandBadArgumentNumberException(this);
            }
            catch (UnrecognizedOptionException e) {
                throw new CommandBadArgumentNumberException(this);
            }
            catch (MissingArgumentException e) {
                throw new CommandMissingArgumentException(e.getOption());
            }
            catch (ParseException e) {
                throw new CommandException(e);
            }
            catch (MalformedURLException e) {
                throw new CommandException(e);
            }
            catch (ArtifactAdministrationException e) {
                throw new CommandException(e);
            }
        }
    }

    @Override
    public Options createOptions() {
        Options options = new Options();
        OptionGroup op = new OptionGroup();
        op.addOption(BULK_OPTION);
        op.addOption(Constants.CommonOption.ARTIFACT_OPTION);
        op.addOption(Constants.CommonOption.URL_OPTION);
        options.addOptionGroup(op);
        return options;
    }

    @Override
    public Map<String, Completer> getOptionCompleters() {
        Utils.addArtifactTypeAndNameCompleter((PetalsInteractiveCli)this.getShell(), this.artifactAdministration, this.completers);
        return this.completers;
    }

    static {
        OptionBuilder.withLongOpt("bulk");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Stop and uninstall or undeploy all JBI artifacts");
        BULK_OPTION = OptionBuilder.create('b');
    }
}

