/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons;

import com.ebmwebsourcing.easycommons.properties.PropertiesHelper;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.io.File;
import java.util.Properties;
import javax.jbi.messaging.FlowAttributes;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.commons.PetalsExecutionContext;

public class PetalsExecutionContextTest {
    @After
    public void after() {
        ExecutionContext.getProperties().clear();
    }

    @Test
    public void testPutDefaultProperties() throws Exception {
        PetalsExecutionContext.putDefaultProperties();
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("logSubdir", "");
        expectedProperties.setProperty("logFilename", "petals.log");
        Assert.assertEquals((Object)expectedProperties, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
    }

    @Test
    public void testPutFlowInstanceId() throws Exception {
        PetalsExecutionContext.putFlowInstanceId((String)"flowInstanceId");
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("logSubdir", "flow-monitoring" + File.separator + "flowInstanceId");
        expectedProperties.setProperty("flowInstanceId", "flowInstanceId");
        Assert.assertEquals((Object)expectedProperties, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
    }

    @Test
    public void testInitFlowInstanceId() throws Exception {
        PetalsExecutionContext.initFlowInstanceId();
        Properties contextualProperties = PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties());
        String flowInstanceId = contextualProperties.getProperty("flowInstanceId");
        Assert.assertNotNull((Object)flowInstanceId);
        Assert.assertTrue((!flowInstanceId.isEmpty() ? 1 : 0) != 0);
        String flowLogSubDir = "flow-monitoring" + File.separator + flowInstanceId;
        Assert.assertEquals((Object)flowLogSubDir, (Object)contextualProperties.get("logSubdir"));
    }

    @Test
    public void testPutFlowStepId() throws Exception {
        PetalsExecutionContext.putFlowStepId((String)"flowStepId");
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("flowStepId", "flowStepId");
        Assert.assertEquals((Object)expectedProperties, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
    }

    @Test
    public void testInitStepInstanceId() throws Exception {
        PetalsExecutionContext.nextFlowStepId();
        Properties contextualProperties = PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties());
        String flowStepId = contextualProperties.getProperty("flowStepId");
        Assert.assertNotNull((Object)flowStepId);
        Assert.assertTrue((!flowStepId.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetFlowAttributesButNoneInContext() throws Exception {
        Assert.assertNull((Object)PetalsExecutionContext.getFlowAttributes());
    }

    @Test
    public void testGetFlowAttributesButFlowInstanceIdMissingInContext() throws Exception {
        ExecutionContext.getProperties().setProperty("flowStepId", "flowStepId1");
        Assert.assertNull((Object)PetalsExecutionContext.getFlowAttributes());
    }

    @Test
    public void testGetFlowAttributesButFlowStepIdMissingInContext() throws Exception {
        ExecutionContext.getProperties().setProperty("flowInstanceId", "flowInstanceId1");
        Assert.assertNull((Object)PetalsExecutionContext.getFlowAttributes());
    }

    @Test
    public void testGetFlowAttributes() throws Exception {
        ExecutionContext.getProperties().setProperty("flowInstanceId", "flowInstanceId1");
        ExecutionContext.getProperties().setProperty("flowStepId", "flowStepId1");
        FlowAttributes expectedFlowAttributes = new FlowAttributes("flowInstanceId1", "flowStepId1");
        Assert.assertEquals((Object)expectedFlowAttributes, (Object)PetalsExecutionContext.getFlowAttributes());
    }

    @Test
    public void testPutFlowAttributes() throws Exception {
        FlowAttributes flowAttributes = new FlowAttributes("flowInstanceId1", "flowStepId1");
        PetalsExecutionContext.putFlowAttributes((FlowAttributes)flowAttributes);
        Assert.assertEquals((Object)"flowInstanceId1", (Object)ExecutionContext.getProperties().getProperty("flowInstanceId"));
        Assert.assertEquals((Object)"flowStepId1", (Object)ExecutionContext.getProperties().getProperty("flowStepId"));
        Assert.assertEquals((Object)("flow-monitoring" + File.separator + "flowInstanceId1"), (Object)ExecutionContext.getProperties().getProperty("logSubdir"));
    }

    @Test
    public void testPutPetalsFileHandlerBaseDir() {
        String testPetalsFileHandlerBasedir = "testPetalsFileHandlerBasedir";
        PetalsExecutionContext.putPetalsFileHandlerBaseDir((String)"testPetalsFileHandlerBasedir");
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("petalsFileHandlerBasedir", "testPetalsFileHandlerBasedir");
        Assert.assertEquals((Object)expectedProperties, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
    }

    @Test
    public void testNextFlowStepId() {
        PetalsExecutionContext.putDefaultProperties();
        PetalsExecutionContext.putFlowStepId((String)"flowStepId1");
        PetalsExecutionContext.nextFlowStepId();
        Assert.assertEquals((Object)ExecutionContext.getProperties().get("flowPreviousStepId"), (Object)"flowStepId1");
        Assert.assertNotSame((Object)ExecutionContext.getProperties().get("flowStepId"), (Object)"flowStepId1");
    }

    @Test
    public void testPutFlowStepInterfaceName() throws Exception {
        PetalsExecutionContext.putFlowStepInterfaceName((QName)new QName("http://org.ow2.petals.test/", "flowStepInterfaceName1"));
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("flowStepInterfaceName", "{http://org.ow2.petals.test/}flowStepInterfaceName1");
        Assert.assertEquals((Object)expectedProperties, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
    }

    @Test
    public void testPutFlowStepOperationName() throws Exception {
        PetalsExecutionContext.putFlowStepOperationName((QName)new QName("http://org.ow2.petals.test/", "flowStepOperationName1"));
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("flowStepOperationName", "{http://org.ow2.petals.test/}flowStepOperationName1");
        Assert.assertEquals((Object)expectedProperties, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
    }

    @Test
    public void testPutFlowStepServiceName() throws Exception {
        PetalsExecutionContext.putFlowStepServiceName((QName)new QName("http://org.ow2.petals.test/", "flowStepServiceName1"));
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("flowStepServiceName", "{http://org.ow2.petals.test/}flowStepServiceName1");
        Assert.assertEquals((Object)expectedProperties, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
    }

    @Test
    public void testPutFlowStepEndpointName() throws Exception {
        PetalsExecutionContext.putFlowStepEndpointName((String)"flowStepEndpointName1");
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("flowStepEndpointName", "flowStepEndpointName1");
        Assert.assertEquals((Object)expectedProperties, (Object)PropertiesHelper.flattenProperties((Properties)ExecutionContext.getProperties()));
    }
}

