/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.dump;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.io.File;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.commons.dump.DumpFileGenerator;
import org.ow2.petals.commons.logger.TraceCode;

public class DumpFileGeneratorTest {
    private static final String TEST_PETALS_FILEHANDLER_BASEDIR = "/home/user/tools/petals/logs";
    private static final String TEST_FLOW_INSTANCE_ID = "myFlowInstanceId";
    private static final String TEST_FLOW_STEP_ID = "myFlowStepId";
    private static final TraceCode TEST_TRACE_CODE = TraceCode.PROVIDE_FLOW_STEP_BEGIN;

    @BeforeClass
    public static void beforeClass() {
        PetalsExecutionContext.putPetalsFileHandlerBaseDir((String)TEST_PETALS_FILEHANDLER_BASEDIR);
        PetalsExecutionContext.putFlowInstanceId((String)TEST_FLOW_INSTANCE_ID);
        PetalsExecutionContext.putFlowStepId((String)TEST_FLOW_STEP_ID);
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("petals.home");
        ExecutionContext.getProperties().clear();
    }

    @Test
    public void testGetUniqueDumpFileReturnNotNullFile() {
        File dumpFile = DumpFileGenerator.getDumpFile((TraceCode)TEST_TRACE_CODE);
        TestCase.assertNotNull((Object)dumpFile);
        TestCase.assertNotNull((Object)dumpFile.getAbsolutePath());
    }

    @Test
    public void testGetUniqueDumpFileReturnExpectedFilePathPattern() {
        String expectedFilePathPattern = TEST_PETALS_FILEHANDLER_BASEDIR + File.separator + "" + "flow-monitoring" + File.separator + TEST_FLOW_INSTANCE_ID + File.separator + TEST_FLOW_STEP_ID + "_" + TEST_TRACE_CODE + ".xml";
        File dumpFile = DumpFileGenerator.getDumpFile((TraceCode)TEST_TRACE_CODE);
        TestCase.assertTrue((String)String.format("File path doesn't match expected pattern '%s': %s", expectedFilePathPattern, dumpFile.getAbsolutePath()), (boolean)dumpFile.getAbsolutePath().equals(expectedFilePathPattern));
    }

    @Test
    public void testGetUniqueDumpFileDontReturnDirectory() {
        File dumpFile = DumpFileGenerator.getDumpFile((TraceCode)TEST_TRACE_CODE);
        Assert.assertFalse((String)"Returned file mustn't be a directory", (boolean)dumpFile.isDirectory());
    }
}

