/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Configuration {
    private final String configurationName;
    private final Map<String, String> parameters;
    private final List<URL> resourceUrls;

    public Configuration(String configurationName) {
        assert (configurationName != null);
        this.configurationName = configurationName;
        this.parameters = new HashMap<String, String>();
        this.resourceUrls = new ArrayList<URL>();
    }

    public final String getConfigurationName() {
        return this.configurationName;
    }

    public final String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public final boolean hasParameter(String parameterName) {
        assert (parameterName != null);
        return this.parameters.containsKey(parameterName);
    }

    public final String getParameter(String parameterName) {
        assert (parameterName != null);
        return this.parameters.get(parameterName);
    }

    public final void setParameter(String parameterName, String parameterValue) {
        assert (parameterName != null);
        assert (parameterValue != null);
        this.parameters.put(parameterName, parameterValue);
    }

    public final void addResource(URL resourceUrl) {
        assert (resourceUrl != null);
        this.resourceUrls.add(resourceUrl);
    }

    public final URL[] getResources() {
        return this.resourceUrls.toArray(new URL[this.resourceUrls.size()]);
    }
}

