/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.petals.component.api.Configuration;

public final class ServiceConfiguration
extends Configuration {
    private final List<ServiceConfiguration> serviceConfigurationDependencies;
    private final ServiceType serviceType;
    private final QName interfaceQName;
    private final QName serviceQName;
    private final String endpointName;
    private final URL serviceDescription;

    public ServiceConfiguration(String configurationName, QName interfaceQName, QName serviceQName, String endpointName, ServiceType serviceType, URL serviceDescription) {
        super(configurationName);
        assert (interfaceQName != null);
        assert (serviceQName != null);
        assert (endpointName != null);
        assert (serviceType != null);
        this.interfaceQName = interfaceQName;
        this.serviceQName = serviceQName;
        this.endpointName = endpointName;
        this.serviceType = serviceType;
        this.serviceDescription = serviceDescription;
        this.serviceConfigurationDependencies = new ArrayList<ServiceConfiguration>();
    }

    public ServiceConfiguration(String configurationName, QName interfaceName, QName serviceName, String endpointName, ServiceType serviceType) {
        this(configurationName, interfaceName, serviceName, endpointName, serviceType, null);
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public final String getEndpointName() {
        return this.endpointName;
    }

    public URL getServiceDescription() {
        return this.serviceDescription;
    }

    public QName getInterfaceQName() {
        return this.interfaceQName;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public void addServiceConfigurationDependency(ServiceConfiguration serviceConfiguration) {
        assert (serviceConfiguration != null);
        this.serviceConfigurationDependencies.add(serviceConfiguration);
    }

    public ServiceConfiguration getServiceConfigurationDependency(int index) {
        return this.serviceConfigurationDependencies.get(index);
    }

    public ServiceConfiguration[] getServiceConfigurationDependencies() {
        return this.serviceConfigurationDependencies.toArray(new ServiceConfiguration[this.serviceConfigurationDependencies.size()]);
    }

    public static enum ServiceType {
        PROVIDE,
        CONSUME;

    }
}

