/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.exception.LoggerDoesNotExistException;
import org.ow2.petals.jmx.exception.LoggerServiceErrorException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;

public class LoggerServiceClient
extends AbstractServiceClient {
    private static final String SET_LEVEL_FOR_LOGGER = "setLevelForLogger";
    private static final String GET_LEVEL_FOR_LOGGER = "getLevelForLogger";
    private static final String GET_ALL_LEVELS = "getAllLevels";
    private static final String GET_ALL_LOGGERS = "getAllLoggers";
    private static final String LOGGER_SERVICE_JMX_NAME = "PetalsLogger";

    public LoggerServiceClient(String petalsDomain, MBeanServerConnection mBeanServerConnection) throws LoggerServiceErrorException, LoggerDoesNotExistException {
        super(petalsDomain, mBeanServerConnection);
        try {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put("name", LOGGER_SERVICE_JMX_NAME);
            attributes.put("type", "service");
            ObjectName objName = new ObjectName(petalsDomain, attributes);
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            if (objNames == null || objNames.size() != 1) {
                throw new LoggerDoesNotExistException();
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (MalformedObjectNameException e) {
            throw new LoggerServiceErrorException(e);
        }
        catch (IOException e) {
            throw new LoggerServiceErrorException(e);
        }
    }

    public void setLevelForLogger(String logger, String level) throws LoggerServiceErrorException {
        Object[] objectsLoad = new Object[]{logger, level};
        String[] stringsLoad = new String[]{String.class.getName(), String.class.getName()};
        try {
            this.performAction(SET_LEVEL_FOR_LOGGER, objectsLoad, stringsLoad);
        }
        catch (PerformActionErrorException e) {
            throw new LoggerServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new LoggerServiceErrorException("Unexpected result type");
        }
    }

    public String getLevelForLogger(String logger) throws LoggerServiceErrorException {
        Object[] objectsLoad = new Object[]{logger};
        String[] stringsLoad = new String[]{String.class.getName()};
        try {
            return (String)this.performAction(GET_LEVEL_FOR_LOGGER, objectsLoad, stringsLoad);
        }
        catch (PerformActionErrorException e) {
            throw new LoggerServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new LoggerServiceErrorException("Unexpected result type");
        }
    }

    public String[] getAllLevels() throws LoggerServiceErrorException {
        try {
            return (String[])this.performAction(GET_ALL_LEVELS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new LoggerServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new LoggerServiceErrorException("Unexpected result type");
        }
    }

    public String[][] getAllLoggers() throws LoggerServiceErrorException {
        try {
            return (String[][])this.performAction(GET_ALL_LOGGERS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new LoggerServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new LoggerServiceErrorException("Unexpected result type");
        }
    }
}

