/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.ws.client;

import java.util.HashMap;
import java.util.Map;
import org.ow2.petals.kernel.ws.client.ArtifactRepositoryServiceClient;
import org.ow2.petals.kernel.ws.client.DeploymentServiceClient;
import org.ow2.petals.kernel.ws.client.EndpointServiceClient;
import org.ow2.petals.kernel.ws.client.InformationServiceClient;
import org.ow2.petals.kernel.ws.client.InstallationServiceClient;
import org.ow2.petals.kernel.ws.client.JBIArtefactsServiceClient;
import org.ow2.petals.kernel.ws.client.MonitoringManagementServiceClient;
import org.ow2.petals.kernel.ws.client.RemoteManagementServiceClient;
import org.ow2.petals.kernel.ws.client.RuntimeServiceClient;
import org.ow2.petals.kernel.ws.client.ServiceAssemblyStateServiceClient;
import org.ow2.petals.kernel.ws.client.TopologyServiceClient;

public class KernelWSFactory {
    private static KernelWSFactory instance = null;
    private Map<String, TopologyServiceClient> topologyServiceClients = new HashMap<String, TopologyServiceClient>();
    private Map<String, DeploymentServiceClient> deploymentServiceClients = new HashMap<String, DeploymentServiceClient>();
    private Map<String, EndpointServiceClient> endpointServiceClients = new HashMap<String, EndpointServiceClient>();
    private Map<String, InformationServiceClient> informationServiceClients = new HashMap<String, InformationServiceClient>();
    private Map<String, InstallationServiceClient> installationServiceClients = new HashMap<String, InstallationServiceClient>();
    private Map<String, JBIArtefactsServiceClient> jbiArtefactsServiceClients = new HashMap<String, JBIArtefactsServiceClient>();
    private Map<String, MonitoringManagementServiceClient> monitoringManagementServiceClients = new HashMap<String, MonitoringManagementServiceClient>();
    private Map<String, RemoteManagementServiceClient> remoteManagementServiceClients = new HashMap<String, RemoteManagementServiceClient>();
    private Map<String, RuntimeServiceClient> runtimeServiceClients = new HashMap<String, RuntimeServiceClient>();
    private Map<String, ServiceAssemblyStateServiceClient> serviceAssemblyStateServiceClients = new HashMap<String, ServiceAssemblyStateServiceClient>();
    private Map<String, ArtifactRepositoryServiceClient> artifactRepositoryServiceClients = new HashMap<String, ArtifactRepositoryServiceClient>();

    private KernelWSFactory() {
    }

    public static synchronized KernelWSFactory getInstance() {
        return instance;
    }

    public synchronized TopologyServiceClient getTopologyServiceClient(String address) {
        TopologyServiceClient client = this.topologyServiceClients.get(address);
        if (client == null) {
            client = new TopologyServiceClient(address);
            this.topologyServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized DeploymentServiceClient getDeploymentServiceClient(String address) {
        DeploymentServiceClient client = this.deploymentServiceClients.get(address);
        if (client == null) {
            client = new DeploymentServiceClient(address);
            this.deploymentServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized EndpointServiceClient getEndpointServiceClient(String address) {
        EndpointServiceClient client = this.endpointServiceClients.get(address);
        if (client == null) {
            client = new EndpointServiceClient(address);
            this.endpointServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized InformationServiceClient getInformationServiceClient(String address) {
        InformationServiceClient client = this.informationServiceClients.get(address);
        if (client == null) {
            client = new InformationServiceClient(address);
            this.informationServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized InstallationServiceClient getInstallationServiceClient(String address) {
        InstallationServiceClient client = this.installationServiceClients.get(address);
        if (client == null) {
            client = new InstallationServiceClient(address);
            this.installationServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized JBIArtefactsServiceClient getJBIArtefactsServiceClient(String address) {
        JBIArtefactsServiceClient client = this.jbiArtefactsServiceClients.get(address);
        if (client == null) {
            client = new JBIArtefactsServiceClient(address);
            this.jbiArtefactsServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized MonitoringManagementServiceClient getMonitoringManagementServiceClient(String address) {
        MonitoringManagementServiceClient client = this.monitoringManagementServiceClients.get(address);
        if (client == null) {
            client = new MonitoringManagementServiceClient(address);
            this.monitoringManagementServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized RemoteManagementServiceClient getRemoteManagementServiceClient(String address) {
        RemoteManagementServiceClient client = this.remoteManagementServiceClients.get(address);
        if (client == null) {
            client = new RemoteManagementServiceClient(address);
            this.remoteManagementServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized RuntimeServiceClient getRuntimeServiceClient(String address) {
        RuntimeServiceClient client = this.runtimeServiceClients.get(address);
        if (client == null) {
            client = new RuntimeServiceClient(address);
            this.runtimeServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized ServiceAssemblyStateServiceClient getServiceAssemblyStateServiceClient(String address) {
        ServiceAssemblyStateServiceClient client = this.serviceAssemblyStateServiceClients.get(address);
        if (client == null) {
            client = new ServiceAssemblyStateServiceClient(address);
            this.serviceAssemblyStateServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized ArtifactRepositoryServiceClient getArtifactRepositoryServiceClient(String address) {
        ArtifactRepositoryServiceClient client = this.artifactRepositoryServiceClients.get(address);
        if (client == null) {
            client = new ArtifactRepositoryServiceClient(address);
            this.artifactRepositoryServiceClients.put(address, client);
        }
        return client;
    }

    public synchronized void removeTopologyServiceClient(String address) {
        this.topologyServiceClients.remove(address);
    }

    public synchronized void removeDeploymentServiceClient(String address) {
        this.deploymentServiceClients.remove(address);
    }

    public synchronized void removeEndpointServiceClient(String address) {
        this.endpointServiceClients.remove(address);
    }

    public synchronized void removeInformationServiceClient(String address) {
        this.informationServiceClients.remove(address);
    }

    public synchronized void removeInstallationServiceClient(String address) {
        this.installationServiceClients.remove(address);
    }

    public synchronized void removeJBIArtefactsServiceClient(String address) {
        this.jbiArtefactsServiceClients.remove(address);
    }

    public synchronized void removeMonitoringManagementServiceClient(String address) {
        this.monitoringManagementServiceClients.remove(address);
    }

    public synchronized void removeRemoteManagementServiceClient(String address) {
        this.remoteManagementServiceClients.remove(address);
    }

    public synchronized void removeRuntimeServiceClient(String address) {
        this.runtimeServiceClients.remove(address);
    }

    public synchronized void removeServiceAssemblyStateServiceClient(String address) {
        this.serviceAssemblyStateServiceClients.remove(address);
    }

    public synchronized void removeArtifactRepositoryServiceClient(String address) {
        this.artifactRepositoryServiceClients.remove(address);
    }

    static {
        instance = new KernelWSFactory();
    }
}

