/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.LoggerHelper;
import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.ow2.petals.commons.dump.DumpFileGenerator;
import org.ow2.petals.commons.logger.ConsumeFlowStepEndLogData;
import org.ow2.petals.commons.logger.ConsumeFlowStepFailureLogData;
import org.ow2.petals.commons.logger.ProvideFlowStepEndDumpLogData;
import org.ow2.petals.commons.logger.ProvideFlowStepEndLogData;
import org.ow2.petals.commons.logger.ProvideFlowStepFailureDumpLogData;
import org.ow2.petals.commons.logger.ProvideFlowStepFailureLogData;
import org.ow2.petals.commons.logger.TraceCode;
import org.ow2.petals.component.framework.api.message.Exchange;

public final class LoggingUtil {
    private static final String ERROR_MESSAGE_LINE_SEPARATOR = " - ";
    private static final String BUSINESS_ERROR_MESSAGE = "A business error occurs";
    private static final String UNKNOWN_ERROR_MESSAGE = "A unknown error occurs (%s)";

    private LoggingUtil() {
    }

    public static final void addMonitEndOrFailureTrace(Logger logger, Exchange exchange, FlowAttributes flowAttributes) {
        Object flowLogData;
        String flowInstanceId = null;
        String flowStepId = null;
        if (flowAttributes != null) {
            flowInstanceId = flowAttributes.getFlowInstanceId();
            flowStepId = flowAttributes.getFlowStepId();
        }
        Fault fault = exchange.getFault();
        if (!exchange.isErrorStatus() && fault == null) {
            if (exchange.isConsumerRole()) {
                flowLogData = new ConsumeFlowStepEndLogData(flowInstanceId, flowStepId);
            } else {
                if (LoggingUtil.isDumpEnabled(logger)) {
                    try {
                        if (flowAttributes != null && exchange.isOutMessage()) {
                            Source outMessageContentAsSource = exchange.getOutMessageContentAsSource();
                            File dumpFile = LoggingUtil.dumpMessageContent(outMessageContentAsSource, TraceCode.PROVIDE_FLOW_STEP_END);
                            logger.log(Level.MONIT_MSG, "", new ProvideFlowStepEndDumpLogData(flowInstanceId, flowStepId, dumpFile.getAbsolutePath()));
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Cannot dump mesage content", e);
                    }
                }
                flowLogData = new ProvideFlowStepEndLogData(flowInstanceId, flowStepId);
            }
        } else {
            String failureMessage;
            if (LoggingUtil.isDumpEnabled(logger)) {
                try {
                    if (flowAttributes != null && fault != null) {
                        Source faultContent = fault.getContent();
                        File dumpFile = LoggingUtil.dumpMessageContent(faultContent, TraceCode.PROVIDE_FLOW_STEP_FAILURE);
                        logger.log(Level.MONIT_MSG, "", new ProvideFlowStepFailureDumpLogData(flowInstanceId, flowStepId, dumpFile.getAbsolutePath()));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Cannot dump mesage content", e);
                }
            }
            if (exchange.isErrorStatus()) {
                Exception error = exchange.getError();
                assert (error != null);
                String message = error.getMessage();
                failureMessage = message != null ? message.replace("\n", ERROR_MESSAGE_LINE_SEPARATOR) : String.format(UNKNOWN_ERROR_MESSAGE, error.getStackTrace()[0].toString());
            } else {
                failureMessage = BUSINESS_ERROR_MESSAGE;
            }
            flowLogData = exchange.isConsumerRole() ? new ConsumeFlowStepFailureLogData(flowInstanceId, flowStepId, failureMessage) : new ProvideFlowStepFailureLogData(flowInstanceId, flowStepId, failureMessage);
        }
        logger.log(Level.MONIT, "", flowLogData);
    }

    public static final File dumpMessageContent(Source source, TraceCode traceCode) throws IOException, TransformerException {
        Source faultMessageContentAsSource = SourceHelper.fork((Source)source);
        File dumpFile = DumpFileGenerator.getDumpFile((TraceCode)traceCode);
        dumpFile.getParentFile().mkdirs();
        SourceHelper.toFile((Source)faultMessageContentAsSource, (File)dumpFile);
        return dumpFile;
    }

    public static final void addMonitFailureTrace(Logger logger, FlowAttributes flowAttributes, String failureMessage, MessageExchange.Role role) {
        failureMessage = failureMessage.replace("\n", ERROR_MESSAGE_LINE_SEPARATOR);
        String flowInstanceId = null;
        String flowStepId = null;
        if (flowAttributes != null) {
            flowInstanceId = flowAttributes.getFlowInstanceId();
            flowStepId = flowAttributes.getFlowStepId();
        }
        Object flowLogData = role == MessageExchange.Role.CONSUMER ? new ConsumeFlowStepFailureLogData(flowInstanceId, flowStepId, failureMessage) : new ProvideFlowStepFailureLogData(flowInstanceId, flowStepId, failureMessage);
        logger.log(Level.MONIT, "", flowLogData);
    }

    public static final boolean isDumpEnabled(Logger logger) {
        boolean isDumpEnabled = logger.isLoggable(Level.MONIT_MSG);
        if (isDumpEnabled) {
            isDumpEnabled = false;
            List handlers = LoggerHelper.getHandlersOrParentHanders((Logger)logger);
            for (Handler handler : handlers) {
                if (handler.getLevel().intValue() > Level.MONIT_MSG.intValue()) continue;
                isDumpEnabled = true;
                break;
            }
        }
        return isDumpEnabled;
    }
}

