/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.async.DynamicRouterAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.AbstractTest;
import org.ow2.petals.se.eip.patterns.DynamicRouter;
import org.ow2.petals.se.eip.patterns.Router;
import org.ow2.petals.se.eip.patterns.SourceKind;
import org.ow2.petals.se.eip.patterns.mock.ExchangeImplMock;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class DynamicRouterTest
extends AbstractTest {
    private DynamicRouter dynamicRouter;
    private Document in1;
    private Document out1;
    private Document out2;
    private Document out3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dynamicRouter = new DynamicRouter();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = Router.class.getResourceAsStream("/dynamicRouterIn1.xml");
            this.in1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Router.class.getResourceAsStream("/dynamicRouterOut1.xml");
            this.out1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Router.class.getResourceAsStream("/dynamicRouterOut2.xml");
            this.out2 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Router.class.getResourceAsStream("/dynamicRouterOut3.xml");
            this.out3 = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.dynamicRouter = null;
        this.in1 = null;
        this.out1 = null;
        this.out2 = null;
        this.out3 = null;
    }

    @Test
    public void testProcessDOM() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.dynamicRouter);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)"router", (Object)exchangeList.get(0).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessStream() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.dynamicRouter);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)"router", (Object)exchangeList.get(0).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncDOM() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setDOMKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            DynamicRouterAsyncContext eipAsyncContext = new DynamicRouterAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList, this.getConditionList());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.dynamicRouter, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(0).isDoneStatus());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(1).isActiveStatus());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncStream() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            DynamicRouterAsyncContext eipAsyncContext = new DynamicRouterAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList, this.getConditionList());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.dynamicRouter, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(0).isDoneStatus());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(1).isActiveStatus());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncTest1DOM() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setDOMKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            DynamicRouterAsyncContext eipAsyncContext = new DynamicRouterAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList, this.getConditionList());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.dynamicRouter, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(0).isDoneStatus());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(1).getInMessage().getContent())));
            Assert.assertEquals((Object)"test1", (Object)this.context.getExchangeList().get(1).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncTest1Stream() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            DynamicRouterAsyncContext eipAsyncContext = new DynamicRouterAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList, this.getConditionList());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.dynamicRouter, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(0).isDoneStatus());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(1).getInMessage().getContent())));
            Assert.assertEquals((Object)"test1", (Object)this.context.getExchangeList().get(1).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncTest2DOM() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setDOMKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            DynamicRouterAsyncContext eipAsyncContext = new DynamicRouterAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList, this.getConditionList());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.dynamicRouter, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(0).isDoneStatus());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(1).getInMessage().getContent())));
            Assert.assertEquals((Object)"test2", (Object)this.context.getExchangeList().get(1).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncTest2Stream() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            DynamicRouterAsyncContext eipAsyncContext = new DynamicRouterAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList, this.getConditionList());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.dynamicRouter, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(0).isDoneStatus());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(1).getInMessage().getContent())));
            Assert.assertEquals((Object)"test2", (Object)this.context.getExchangeList().get(1).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncDefaultDOM() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setDOMKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            DynamicRouterAsyncContext eipAsyncContext = new DynamicRouterAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList, this.getConditionList());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out3, null, null, (AbstractPattern)this.dynamicRouter, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(0).isDoneStatus());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(1).getInMessage().getContent())));
            Assert.assertEquals((Object)"default", (Object)this.context.getExchangeList().get(1).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncDefaultStream() {
        try {
            this.dynamicRouter.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            DynamicRouterAsyncContext eipAsyncContext = new DynamicRouterAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList, this.getConditionList());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out3, null, null, (AbstractPattern)this.dynamicRouter, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertTrue((boolean)this.context.getExchangeList().get(0).isDoneStatus());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(1).getInMessage().getContent())));
            Assert.assertEquals((Object)"default", (Object)this.context.getExchangeList().get(1).getOperation().getLocalPart());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testInit() {
        try {
            this.dynamicRouter.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    @Override
    public List<Param> getParamList() {
        CopyOnWriteArrayList<Param> paramList = new CopyOnWriteArrayList<Param>();
        Param param = new Param();
        param.setName("test");
        param.setValue("boolean(/*[local-name()='PublishContractResponse' and namespace-uri()='http://www.petals.org/ContractService1'])");
        paramList.add(param);
        param = new Param();
        param.setName("test");
        param.setValue("boolean(/*[local-name()='PublishContractResponse' and namespace-uri()='http://www.petals.org/ContractService2'])");
        paramList.add(param);
        return paramList;
    }

    private List<String> getConditionList() {
        CopyOnWriteArrayList<String> conditionList = new CopyOnWriteArrayList<String>();
        for (Param param : this.getParamList()) {
            if (!"test".equals(param.getName())) continue;
            conditionList.add(param.getValue());
        }
        return conditionList;
    }

    private List<Consumes> getConsumesList(MEPType mepType) {
        CopyOnWriteArrayList<Consumes> consumesList = new CopyOnWriteArrayList<Consumes>();
        QName interfaceName = null;
        QName serviceName = null;
        String endpoint = null;
        interfaceName = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "router"));
        consumesList.add(consumes);
        consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test1"));
        consumesList.add(consumes);
        consumes = new Consumes();
        consumes.setMep(MEPType.IN_ONLY);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test2"));
        consumesList.add(consumes);
        consumes = new Consumes();
        consumes.setMep(MEPType.IN_ONLY);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "default"));
        consumesList.add(consumes);
        return consumesList;
    }
}

