/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.AbstractTest;
import org.ow2.petals.se.eip.patterns.WireTap;
import org.ow2.petals.se.eip.patterns.mock.ExchangeContextMock;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class WireTapTest
extends AbstractTest {
    private WireTap wireTap;
    private Document in1;
    private Document in2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.wireTap = new WireTap();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = WireTap.class.getResourceAsStream("/wireTapIn1.xml");
            this.in1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = WireTap.class.getResourceAsStream("/wireTapIn2.xml");
            this.in2 = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.wireTap = null;
        this.in1 = null;
        this.in2 = null;
    }

    @Test
    public void testInit() {
        try {
            this.wireTap.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    @Override
    public List<Param> getParamList() {
        return null;
    }

    private List<Param> getParamList(String way) {
        ArrayList<Param> paramList = new ArrayList<Param>();
        Param param = new Param();
        param.setName("wiretap-way");
        param.setValue(way);
        paramList.add(param);
        return paramList;
    }

    private void createContext(String way) {
        this.context = new ExchangeContextMock(new ConfigurationExtensions(this.getParamList(way)));
    }

    private List<Consumes> getConsumesList(MEPType mepType) {
        CopyOnWriteArrayList<Consumes> consumesList = new CopyOnWriteArrayList<Consumes>();
        QName interfaceName = null;
        QName serviceName = null;
        String endpoint = null;
        interfaceName = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test1"));
        consumesList.add(consumes);
        consumes = new Consumes();
        consumes.setMep(MEPType.IN_ONLY);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test2"));
        consumesList.add(consumes);
        return consumesList;
    }

    @Test
    public void testProcessDOM() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertNotNull((Object)exchange.getOutMessage());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessStream() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertNotNull((Object)exchange.getOutMessage());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestWithInOnlyConsumesWithDone() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyResponseWithInOnlyConsumesWithDone() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestResponseWithInOnlyConsumesWithDone() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestOnResponseWithInOnlyConsumesWithDone() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestWithInOnlyConsumesWithError() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyResponseWithInOnlyConsumesWithError() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestResponseWithInOnlyConsumesWithError() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestOnResponseWithInOnlyConsumesWithError() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyResponseWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestResponseWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestOnResponseWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyResponseWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestResponseWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestOnResponseWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyResponseWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestResponseWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)4L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestOnResponseWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestWithInOutConsumesWithOut() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyResponseWithInOutConsumesWithOut() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestResponseWithInOutConsumesWithOut() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)4L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestOnResponseWithInOutConsumesWithOut() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestWithInOutConsumesWithFault() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyResponseWithInOutConsumesWithFault() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestResponseWithInOutConsumesWithFault() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)4L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyRequestOnResponseWithInOutConsumesWithFault() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestWithInOnlyConsumesWithDone() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyResponseWithInOnlyConsumesWithDone() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestResponseWithInOnlyConsumesWithDone() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestOnResponseWithInOnlyConsumesWithDone() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestWithInOnlyConsumesWithError() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyResponseWithInOnlyConsumesWithError() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestResponseWithInOnlyConsumesWithError() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestOnResponseWithInOnlyConsumesWithError() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyResponseWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestResponseWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestOnResponseWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyResponseWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestResponseWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestOnResponseWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isErrorStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyResponseWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestResponseWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)4L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestOnResponseWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestWithInOutConsumesWithOut() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyResponseWithInOutConsumesWithOut() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestResponseWithInOutConsumesWithOut() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)4L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestOnResponseWithInOutConsumesWithOut() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestWithInOutConsumesWithFault() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyResponseWithInOutConsumesWithFault() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestResponseWithInOutConsumesWithFault() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)4L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyRequestOnResponseWithInOutConsumesWithFault() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestWithInOnlyConsumesWithDone() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutResponseWithInOnlyConsumesWithDone() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestResponseWithInOnlyConsumesWithDone() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestOnResponseWithInOnlyConsumesWithDone() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestWithInOnlyConsumesWithError() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutResponseWithInOnlyConsumesWithError() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestResponseWithInOnlyConsumesWithError() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestOnResponseWithInOnlyConsumesWithError() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutResponseWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestResponseWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestOnResponseWithRobustInOnlyConsumesWithDone() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessinOutResponseWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestResponseWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestOnResponseWithRobustInOnlyConsumesWithError() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNotNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutResponseWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestResponseWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)4L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestOnResponseWithRobustInOnlyConsumesWithFault() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestWithInOutConsumesWithOut() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutResponseWithInOutConsumesWithOut() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestResponseWithInOutConsumesWithOut() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)4L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestOnResponseWithInOutConsumesWithOut() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestWithInOutConsumesWithFault() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutResponseWithInOutConsumesWithFault() {
        try {
            this.createContext("response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestResponseWithInOutConsumesWithFault() {
        try {
            this.createContext("request-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)4L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutRequestOnResponseWithInOutConsumesWithFault() {
        try {
            this.createContext("request-on-response");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(true);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNotNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOptionalOutRequestWithInOutConsumesWithOut() {
        try {
            this.createContext("request");
            this.wireTap.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OPTIONAL_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in2, null, null, null, (AbstractPattern)this.wireTap);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)3L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in2), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in2), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()));
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<content>The context set an out</content>\n", (String)result));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }
}

