/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns.mock;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.petals.se.eip.patterns.mock.FaultMock;
import org.ow2.petals.se.eip.patterns.mock.NormalizedMessageMock;

public class MessageExchangeMock
implements MessageExchange {
    public static final String IN_MSG = "in";
    public static final URI IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-only");
    public static final URI IN_OPTIONAL_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-opt-out");
    public static final URI IN_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-out");
    public static final String OUT_MSG = "out";
    public static final URI ROBUST_IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/robust-in-only");
    private static final long serialVersionUID = -4354354L;
    private static final short SERIALIZE_ROLE_CONSUMER = 0;
    private static final short SERIALIZE_ROLE_PROVIDER = 1;
    private static final short SERIALIZE_STATUS_ACTIVE = 0;
    private static final short SERIALIZE_STATUS_DONE = 1;
    private static final short SERIALIZE_STATUS_ERROR = 2;
    protected ServiceEndpoint consumerEndpoint;
    protected ServiceEndpoint endpoint;
    protected Exception error;
    protected String exchangeId;
    protected FlowAttributes flowAttributes;
    protected Fault fault;
    protected QName interfaceName;
    protected Map<String, NormalizedMessage> messages = new HashMap<String, NormalizedMessage>();
    protected QName operation;
    protected URI pattern;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected transient MessageExchange.Role role;
    protected QName service;
    protected transient ExchangeStatus status;
    protected boolean terminated;
    protected boolean transacted;
    private boolean checkRole = false;

    public MessageExchangeMock(ServiceEndpoint consumerEndpoint, URI uri, MessageExchange.Role role, ExchangeStatus status) {
        this.status = status;
        this.role = role;
        this.consumerEndpoint = consumerEndpoint;
        this.pattern = uri;
        this.checkRole = true;
    }

    public MessageExchangeMock(URI uri, MessageExchange.Role role) {
        this.status = ExchangeStatus.ACTIVE;
        this.role = role;
        this.pattern = uri;
        this.checkRole = true;
    }

    public void setCheckRole(boolean checkRole) {
        this.checkRole = checkRole;
    }

    public Fault createFault() throws MessagingException {
        return new FaultMock();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return new NormalizedMessageMock();
    }

    public ServiceEndpoint getConsumerEndpoint() {
        return this.consumerEndpoint;
    }

    public ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.endpoint;
    }

    public Exception getError() {
        return this.error;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public Fault getFault() {
        return this.fault;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public NormalizedMessage getMessage(String name) {
        if (name != null) {
            return this.messages.get(name.toLowerCase());
        }
        return null;
    }

    public Map<String, NormalizedMessage> getMessages() {
        return this.messages;
    }

    public QName getOperation() {
        return this.operation;
    }

    public URI getPattern() {
        return this.pattern;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<?> getPropertyNames() {
        return this.properties.keySet();
    }

    public MessageExchange.Role getRole() {
        return this.role;
    }

    public QName getService() {
        return this.service;
    }

    public ExchangeStatus getStatus() {
        return this.status;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setError(Exception error) {
        this.error = error;
        try {
            this.setStatus(ExchangeStatus.ERROR);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    public void setFault(Fault fault) throws MessagingException {
        this.checkNotTerminated();
        if (this.role == null) {
            throw new MessagingException("The Role is not defined.");
        }
        if (ExchangeStatus.DONE.equals(this.status) || ExchangeStatus.ERROR.equals(this.status)) {
            throw new MessagingException("The MessageExchange state and the current Role do not allow this operation.");
        }
        if (this.checkRole && MessageExchange.Role.CONSUMER.equals(this.role) && (!IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) || !this.messages.containsKey(OUT_MSG))) {
            throw new MessagingException("The MessageExchange state and the current Role do not allow this operation.");
        }
        this.fault = fault;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void setMessage(NormalizedMessage msg, String name) throws MessagingException {
        this.checkNotTerminated();
        if (msg == null) {
            throw new MessagingException("NormalizedMessage must be non null.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new MessagingException("The message reference must be non null and non empty.");
        }
        this.checkPatternMatching(name);
        if (this.messages.containsKey(name.toLowerCase())) {
            throw new MessagingException("A message has already been set with the '" + name + "' reference.");
        }
        this.messages.put(name.toLowerCase(), msg);
    }

    public void setOperation(QName name) {
        this.operation = name;
    }

    public void setPattern(URI pattern) {
        this.pattern = pattern;
    }

    public void setProperty(String name, Object obj) {
        this.properties.put(name, obj);
    }

    public void setRole(MessageExchange.Role role) {
        this.role = role;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public void setStatus(ExchangeStatus status) throws MessagingException {
        this.checkNotTerminated();
        if (ExchangeStatus.DONE.equals(status)) {
            if (MessageExchange.Role.CONSUMER.equals(this.role)) {
                if (IN_ONLY_PATTERN.equals(this.pattern)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (IN_OUT_PATTERN.equals(this.pattern) && this.fault == null && this.getMessage(OUT_MSG) == null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) && this.fault == null && this.getMessage(OUT_MSG) == null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
            } else {
                if (ROBUST_IN_ONLY_PATTERN.equals(this.pattern) && this.fault != null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (IN_OUT_PATTERN.equals(this.pattern)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (IN_OPTIONAL_OUT_PATTERN.equals(this.pattern)) {
                    if (this.fault != null && this.getMessage(OUT_MSG) == null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                    if (this.fault == null && this.getMessage(OUT_MSG) != null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                }
            }
        } else if (ExchangeStatus.ERROR.equals(status) && MessageExchange.Role.PROVIDER.equals(this.role) && IN_OUT_PATTERN.equals(this.pattern)) {
            throw new MessagingException("The MessageExchange state does not allow this operation.");
        }
        this.status = status;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public String toString() {
        return "MessageExchange@" + this.getExchangeId();
    }

    protected void checkNotTerminated() throws MessagingException {
        if (this.isTerminated()) {
            throw new MessagingException("The Exchange is terminated.");
        }
    }

    protected void checkPatternMatching(String name) throws MessagingException {
        if (this.pattern == null) {
            throw new MessagingException("The MEP is not defined.");
        }
        if (name == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if (IN_MSG.equalsIgnoreCase(name) ? IN_ONLY_PATTERN.equals(this.pattern) || ROBUST_IN_ONLY_PATTERN.equals(this.pattern) || IN_OUT_PATTERN.equals(this.pattern) || IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) : OUT_MSG.equalsIgnoreCase(name) && (IN_OUT_PATTERN.equals(this.pattern) || IN_OPTIONAL_OUT_PATTERN.equals(this.pattern))) {
            return;
        }
        throw new MessagingException("the MessageExchange state does not allow this operation.");
    }

    public void cleanMessages() {
        if (!ExchangeStatus.ACTIVE.equals(this.status)) {
            this.messages.clear();
            this.fault = null;
        }
        if (this.fault != null) {
            this.messages.clear();
        }
        if (this.messages.containsKey(OUT_MSG) && this.messages.containsKey(IN_MSG)) {
            this.messages.remove(IN_MSG);
        }
    }

    protected void readObjectDelegate(ObjectInputStream s) throws IOException {
        switch (s.readShort()) {
            case 0: {
                this.role = MessageExchange.Role.CONSUMER;
                break;
            }
            case 1: {
                this.role = MessageExchange.Role.PROVIDER;
                break;
            }
        }
        switch (s.readShort()) {
            case 0: {
                this.status = ExchangeStatus.ACTIVE;
                break;
            }
            case 1: {
                this.status = ExchangeStatus.DONE;
                break;
            }
            case 2: {
                this.status = ExchangeStatus.ERROR;
                break;
            }
        }
        try {
            s.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getClass() + ":" + e.getMessage());
        }
    }

    protected void writeObjectDelegate(ObjectOutputStream s) throws IOException {
        if (MessageExchange.Role.CONSUMER.equals(this.role)) {
            s.writeShort(0);
        } else {
            s.writeShort(1);
        }
        if (ExchangeStatus.ACTIVE.equals(this.status)) {
            s.writeShort(0);
        } else if (ExchangeStatus.DONE.equals(this.status)) {
            s.writeShort(1);
        } else {
            s.writeShort(2);
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException {
        this.readObjectDelegate(s);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeObjectDelegate(s);
    }

    public void setConsumerEndpoint(ServiceEndpoint serviceEndpoint) {
        this.consumerEndpoint = serviceEndpoint;
    }

    public void setFlowAttributes(FlowAttributes flowAttributes) {
        this.flowAttributes = flowAttributes;
    }

    public FlowAttributes getFlowAttributes() {
        return this.flowAttributes;
    }
}

