/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns.mock;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.xml.transform.Source;

public class NormalizedMessageMock
implements NormalizedMessage {
    public static final String PROPERTY_COMPRESSION = "org.ow2.petals.transport.compress";
    private static final long serialVersionUID = 45438732L;
    protected transient Map<String, DataHandler> attachments;
    protected transient Source content = null;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected Subject subject;

    public NormalizedMessageMock() {
        this.attachments = new HashMap<String, DataHandler>();
    }

    public void addAttachment(String id, DataHandler attachment) throws MessagingException {
        this.attachments.put(id, attachment);
    }

    public DataHandler getAttachment(String id) {
        return this.attachments.get(id);
    }

    public Set<?> getAttachmentNames() {
        return this.attachments.keySet();
    }

    public Source getContent() {
        return this.content;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<?> getPropertyNames() {
        return this.properties.keySet();
    }

    public Subject getSecuritySubject() {
        return this.subject;
    }

    public void removeAttachment(String id) throws MessagingException {
        DataHandler att = this.attachments.remove(id);
        if (att == null) {
            throw new MessagingException(id + " attachment does not exist.");
        }
    }

    public void setContent(Source content) throws MessagingException {
        this.content = content;
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public void setSecuritySubject(Subject securitySubject) {
        this.subject = securitySubject;
    }
}

