/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import java.net.URI;
import java.util.ArrayList;
import javax.jbi.JBIException;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.ExchangeUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.async.RoutingSlipAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractMEPBridgePattern;
import org.ow2.petals.se.eip.patterns.PatternHelper;

public class RoutingSlip
extends AbstractMEPBridgePattern {
    public static final String ROUTING_SLIP_NAME = "Routing-Slip";
    public static final String ROUTING_SLIP_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/routingSlip";

    @Override
    public String getName() {
        return ROUTING_SLIP_NAME;
    }

    @Override
    public String getNameSpace() {
        return ROUTING_SLIP_NAMESPACE;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean process(Exchange exchange, ExchangeContext context) {
        boolean reply = false;
        try {
            ArrayList<Consumes> consumesList = new ArrayList<Consumes>(context.getSUConsumes(exchange.getEndpoint()));
            if (consumesList != null && consumesList.size() >= 1) {
                Consumes consumes = (Consumes)consumesList.get(0);
                Exchange pipedExchange = context.createConsumeExchange(consumes);
                if (pipedExchange.getOperation() == null) {
                    pipedExchange.setOperation(exchange.getOperation());
                }
                PatternHelper.copy(exchange.getInMessage(), pipedExchange.getInMessage());
                ExchangeUtil.copyExchangeProperties((Exchange)exchange, (Exchange)pipedExchange);
                this.logSend(consumes, pipedExchange);
                boolean faultToException = this.isFaultToException(context.getExtensions());
                RoutingSlipAsyncContext routingSlipAsyncContext = new RoutingSlipAsyncContext(exchange, 600000L, faultToException, consumesList);
                context.sendAsync(pipedExchange, routingSlipAsyncContext);
            } else {
                exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define at least 1 Consumes section(s)")));
                reply = true;
            }
        }
        catch (MessagingException e) {
            exchange.setError((Exception)((Object)e));
            reply = true;
        }
        catch (PEtALSCDKException e) {
            exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
            reply = true;
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAsync(Exchange exchange, ExchangeContext context, CommonAsyncContext asyncContext) {
        block19: {
            NormalizedMessage receivedMessage = null;
            try {
                int subMessages = asyncContext.decrementAndGetOngoingSubMessages();
                if (subMessages == 0) {
                    this.processResponse(exchange, context, asyncContext);
                } else {
                    receivedMessage = PatternHelper.processSentExchange(exchange, context);
                    if (!asyncContext.isTerminated()) {
                        if (receivedMessage != null) {
                            Consumes consumes = ((RoutingSlipAsyncContext)asyncContext).getConsumesList().get(((RoutingSlipAsyncContext)asyncContext).getConsumesList().size() - subMessages);
                            Exchange pipedExchange = context.createConsumeExchange(consumes);
                            if (pipedExchange.getOperation() == null) {
                                pipedExchange.setOperation(asyncContext.getOriginalExchange().getOperation());
                            }
                            if (receivedMessage instanceof Fault) {
                                if (asyncContext.isFaultToException()) {
                                    asyncContext.getOriginalExchange().setError((Exception)((Object)new JBIException(SourceUtil.createString((Source)receivedMessage.getContent()))));
                                } else if (asyncContext.getOriginalExchange().isInOnlyPattern()) {
                                    asyncContext.getOriginalExchange().setDoneStatus();
                                } else {
                                    asyncContext.getOriginalExchange().setFault((Fault)receivedMessage);
                                }
                                context.send(asyncContext.getOriginalExchange());
                                asyncContext.setTerminated();
                            } else {
                                PatternHelper.copy(receivedMessage, pipedExchange.getInMessage());
                                ExchangeUtil.copyExchangeProperties((Exchange)asyncContext.getOriginalExchange(), (Exchange)pipedExchange);
                                this.logSend(consumes, pipedExchange);
                                context.sendAsync(pipedExchange, asyncContext);
                            }
                        } else {
                            asyncContext.getOriginalExchange().setError((Exception)((Object)new MessagingException("Terminate the pattern processing due to a Done status received before the end of the global routing")));
                            context.send(asyncContext.getOriginalExchange());
                            asyncContext.setTerminated();
                        }
                    }
                }
            }
            catch (JBIException e) {
                if (asyncContext.isTerminated()) break block19;
                asyncContext.getOriginalExchange().setError((Exception)((Object)e));
                try {
                    context.send(asyncContext.getOriginalExchange());
                }
                catch (MessagingException e1) {
                    this.logger.warning(this.getName() + ": unable to close the source exchange on error status");
                }
                finally {
                    asyncContext.setTerminated();
                }
            }
        }
        return false;
    }

    @Override
    public boolean validateMEP(URI mep) {
        return true;
    }
}

