/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import javax.jbi.JBIException;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.ExchangeUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.PatternHelper;

public class WireTap
extends AbstractPattern {
    public static final String WIRE_TAP_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/wireTap";
    public static final String REQUEST_WAY = "request";
    public static final String RESPONSE_WAY = "response";
    public static final String REQUEST_RESPONSE_WAY = "request-response";
    public static final String REQUEST_ON_RESPONSE_WAY = "request-on-response";

    @Override
    public String getName() {
        return "Wire-Tap";
    }

    @Override
    public String getNameSpace() {
        return WIRE_TAP_NAMESPACE;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean process(Exchange exchange, ExchangeContext context) {
        List<Consumes> consumesList = context.getSUConsumes(exchange.getEndpoint());
        if (consumesList.size() == 2) {
            if (!StringHelper.isNullOrEmpty((String)context.getExtensions().get((Object)"wiretap-way"))) {
                this.sendExchange(consumesList, exchange, context);
            } else {
                exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": parameter '" + "wiretap-way" + "' is mandatory")));
            }
        } else {
            exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define 2 Consumes sections" + this.getName())));
        }
        return true;
    }

    @Override
    public boolean processAsync(Exchange exchange, ExchangeContext context, CommonAsyncContext asyncContext) {
        exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the pattern do not support asynchronous exchanges")));
        return true;
    }

    @Override
    public boolean validateMEP(URI mep) {
        return true;
    }

    private Exchange prepareRequestCopyIfNeeded(Consumes monitor, Exchange exchange, ExchangeContext context) throws PEtALSCDKException, JBIException {
        Exchange monitorExchange = null;
        InputStream inMessageAsStream = PatternHelper.handleStreamSource(exchange.getInMessage());
        monitorExchange = context.createConsumeExchange(monitor);
        if (monitorExchange.getOperation() == null) {
            monitorExchange.setOperation(exchange.getOperation());
        }
        PatternHelper.copy(exchange.getInMessage(), monitorExchange.getInMessage());
        ExchangeUtil.copyExchangeProperties((Exchange)exchange, (Exchange)monitorExchange);
        if (inMessageAsStream != null) {
            exchange.getInMessage().setContent((Source)new StreamSource(inMessageAsStream));
        }
        return monitorExchange;
    }

    private Exchange prepareResponseCopyIfNeeded(Consumes monitor, Exchange targetExchange, ExchangeContext context, QName originalOperation) throws PEtALSCDKException, JBIException {
        Exchange monitorExchange = null;
        if (targetExchange.isActiveStatus()) {
            if (targetExchange.getFault() != null) {
                InputStream faultMessageAsStream = PatternHelper.handleStreamSource((NormalizedMessage)targetExchange.getFault());
                monitorExchange = context.createConsumeExchange(monitor);
                if (monitorExchange.getOperation() == null) {
                    monitorExchange.setOperation(originalOperation);
                }
                PatternHelper.copy((NormalizedMessage)targetExchange.getFault(), monitorExchange.getInMessage());
                ExchangeUtil.copyExchangeProperties((Exchange)targetExchange, (Exchange)monitorExchange);
                if (faultMessageAsStream != null) {
                    targetExchange.getFault().setContent((Source)new StreamSource(faultMessageAsStream));
                }
            } else if (targetExchange.isOutMessage()) {
                InputStream outMessageAsStream = PatternHelper.handleStreamSource(targetExchange.getOutMessage());
                monitorExchange = context.createConsumeExchange(monitor);
                if (monitorExchange.getOperation() == null) {
                    monitorExchange.setOperation(originalOperation);
                }
                PatternHelper.copy(targetExchange.getOutMessage(), monitorExchange.getInMessage());
                ExchangeUtil.copyExchangeProperties((Exchange)targetExchange, (Exchange)monitorExchange);
                if (outMessageAsStream != null) {
                    targetExchange.getOutMessage().setContent((Source)new StreamSource(outMessageAsStream));
                }
            }
        } else if (targetExchange.isErrorStatus()) {
            monitorExchange = context.createConsumeExchange(monitor);
            if (monitorExchange.getOperation() == null) {
                monitorExchange.setOperation(originalOperation);
            }
            monitorExchange.setError(targetExchange.getError());
            ExchangeUtil.copyExchangeProperties((Exchange)targetExchange, (Exchange)monitorExchange);
        }
        return monitorExchange;
    }

    private void prepareSourceExchange(NormalizedMessage receivedMessage, Exchange exchange) throws MessagingException, PEtALSCDKException {
        if (exchange.isActiveStatus()) {
            if (receivedMessage != null) {
                if (receivedMessage instanceof Fault) {
                    if (!exchange.isInOnlyPattern()) {
                        Fault fault = exchange.createFault();
                        PatternHelper.copy(receivedMessage, (NormalizedMessage)fault);
                        exchange.setFault(fault);
                    }
                } else if (!exchange.isInOnlyPattern() && !exchange.isRobustInOnlyPattern()) {
                    PatternHelper.copy(receivedMessage, exchange.getOutMessage());
                }
            } else if (exchange.isInOutPattern()) {
                exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the target exchange doesn't contain an OUT message: unable to process")));
            }
        }
    }

    private void sendExchange(List<Consumes> consumesList, Exchange exchange, ExchangeContext context) {
        block9: {
            Exchange monitorInExchange = null;
            Exchange monitorOutExchange = null;
            try {
                Consumes provider = consumesList.get(0);
                Consumes monitor = consumesList.get(1);
                String way = context.getExtensions().get((Object)"wiretap-way");
                if (REQUEST_WAY.equals(way) || REQUEST_RESPONSE_WAY.equals(way) || REQUEST_ON_RESPONSE_WAY.equals(way)) {
                    monitorInExchange = this.prepareRequestCopyIfNeeded(monitor, exchange, context);
                }
                if (monitorInExchange != null && (REQUEST_WAY.equals(way) || REQUEST_RESPONSE_WAY.equals(way))) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.getName() + ": invocation of the in monitoring service : interface name=" + monitor.getInterfaceName().toString() + " / service name=" + monitor.getServiceName().toString() + " / endpoint name=" + monitor.getEndpointName());
                    }
                    context.send(monitorInExchange);
                }
                Exchange targetExchange = this.sendSyncExchange(provider, exchange, context);
                if (monitorInExchange != null && REQUEST_ON_RESPONSE_WAY.equals(way) && targetExchange.getError() == null && targetExchange.getFault() == null) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.getName() + ": invocation of the in monitoring service : interface name=" + monitor.getInterfaceName().toString() + " / service name=" + monitor.getServiceName().toString() + " / endpoint name=" + monitor.getEndpointName());
                    }
                    context.send(monitorInExchange);
                }
                if ((RESPONSE_WAY.equals(way) || REQUEST_RESPONSE_WAY.equals(way)) && (monitorOutExchange = this.prepareResponseCopyIfNeeded(monitor, targetExchange, context, exchange.getOperation())) != null) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.getName() + ": invocation of the out monitoring service : interface name=" + monitor.getInterfaceName().toString() + " / service name=" + monitor.getServiceName().toString() + " / endpoint name=" + monitor.getEndpointName());
                    }
                    context.send(monitorOutExchange);
                }
                this.prepareSourceExchange(PatternHelper.processSentExchange(targetExchange, context), exchange);
            }
            catch (JBIException e) {
                if (!exchange.isActiveStatus()) break block9;
                exchange.setError((Exception)((Object)e));
            }
        }
    }

    private Exchange sendSyncExchange(Consumes provider, Exchange exchange, ExchangeContext context) throws JBIException {
        Exchange providerExchange = context.createConsumeExchange(provider);
        if (providerExchange.getOperation() == null) {
            providerExchange.setOperation(exchange.getOperation());
        }
        PatternHelper.copy(exchange.getInMessage(), providerExchange.getInMessage());
        ExchangeUtil.copyExchangeProperties((Exchange)exchange, (Exchange)providerExchange);
        this.logSend(provider, providerExchange);
        context.sendSync(providerExchange);
        return providerExchange;
    }
}

