/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.AbstractTest;
import org.ow2.petals.se.eip.patterns.Aggregator;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class AggregatorTest
extends AbstractTest {
    private Aggregator aggregator;
    private Document in1;
    private Document in2;
    private Document inTest;
    private String outResult1;
    private String inResult1;
    private String inResult2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.aggregator = new Aggregator();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = Aggregator.class.getResourceAsStream("/aggregatorIn1.xml");
            this.in1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Aggregator.class.getResourceAsStream("/aggregatorIn2.xml");
            this.in2 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Aggregator.class.getResourceAsStream("/aggregatorInTest.xml");
            this.inTest = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Aggregator.class.getResourceAsStream("/aggregatorOutResult1.xml");
            this.outResult1 = this.convertStreamToString(inputStream);
            inputStream.close();
            inputStream = Aggregator.class.getResourceAsStream("/aggregatorInResult1.xml");
            this.inResult1 = this.convertStreamToString(inputStream);
            inputStream.close();
            inputStream = Aggregator.class.getResourceAsStream("/aggregatorInResult2.xml");
            this.inResult2 = this.convertStreamToString(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.aggregator = null;
        this.in1 = null;
        this.in2 = null;
        this.inTest = null;
        this.inResult1 = null;
        this.inResult2 = null;
        this.outResult1 = null;
    }

    @Test
    public void testXPATHfactory() throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        Assert.assertNotNull((Object)factory);
        XPath xpath = factory.newXPath();
        Assert.assertNotNull((Object)xpath);
        Assert.assertNotNull((Object)XPathFactory.newInstance().newXPath());
    }

    @Test
    public void testProcessDOM() {
        try {
            this.aggregator.init();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.inResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(0).getInMessage().getContent()))));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcess2DOM() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in2, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.inResult2, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(0).getInMessage().getContent()))));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcess2Stream() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in2, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.inResult2, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(0).getInMessage().getContent()))));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessStream() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.inResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)this.context.getExchangeList().get(0).getInMessage().getContent()))));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testInit() {
        try {
            this.aggregator.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    private List<Consumes> getConsumesList(MEPType mepType) {
        CopyOnWriteArrayList<Consumes> consumesList = new CopyOnWriteArrayList<Consumes>();
        QName interfaceName = null;
        QName serviceName = null;
        String endpoint = null;
        interfaceName = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test1"));
        consumesList.add(consumes);
        return consumesList;
    }

    @Override
    public List<Param> getParamList() {
        CopyOnWriteArrayList<Param> paramList = new CopyOnWriteArrayList<Param>();
        Param param = new Param();
        param.setName("test");
        param.setValue("boolean(/*[local-name()='PublishContract' and namespace-uri()='http://www.petals.org/ContractService']/*[local-name()='aggregate'])");
        paramList.add(param);
        param = new Param();
        param.setName("aggregator-correlation");
        param.setValue("/*[local-name()='PublishContract' and namespace-uri()='http://www.petals.org/ContractService']/*[local-name()='AKContract']/*[local-name()='Type']/text()");
        paramList.add(param);
        return paramList;
    }

    @Test
    public void testProcessInOnlyWithInOutConsumesWithOut() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithInOutConsumesWithOut() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() == null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithInOutConsumesWithFault() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setError(false);
            this.context.setFault(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithInOutConsumesWithFault() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setError(false);
            this.context.setFault(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() != null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithInOutConsumesWithFault() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setError(false);
            this.context.setFault(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() != null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithInOutConsumesWithOut() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() == null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithInOnlyConsumesWithDone() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithInOnlyConsumesWithDone() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() == null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithInOnlyConsumesWithError() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setError(true);
            this.context.setFault(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isErrorStatus());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithInOnlyConsumesWithError() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setError(true);
            this.context.setFault(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isErrorStatus());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithInOnlyConsumesWithError() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setError(true);
            this.context.setFault(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getError() != null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithInOnlyConsumesWithDone() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() == null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithRobustInOnlyConsumesWithDone() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithRobustInOnlyConsumesWithError() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setError(true);
            this.context.setFault(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isErrorStatus());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOnlyWithRobustInOnlyConsumesWithFault() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setError(false);
            this.context.setFault(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithRobustInOnlyConsumesWithDone() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() == null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithRobustInOnlyConsumesWithError() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setError(true);
            this.context.setFault(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isErrorStatus());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessRobustInOnlyWithRobustInOnlyConsumesWithFault() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setError(false);
            this.context.setFault(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            exchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() != null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithRobustInOnlyConsumesWithDone() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() == null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithRobustInOnlyConsumesWithError() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setError(true);
            this.context.setFault(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getError() != null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessInOutWithRobustInOnlyConsumesWithFault() {
        try {
            this.aggregator.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.ROBUST_IN_ONLY));
            this.context.setError(false);
            this.context.setFault(true);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.aggregator);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)0L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)this.outResult1, (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getOutMessage().getContent()))));
            exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inTest, null, null, null, (AbstractPattern)this.aggregator);
            exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertTrue((exchange.getFault() != null ? 1 : 0) != 0);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }
}

