/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractMEPBridgeWithUnicConsumesPatternTest;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.Bridge;
import org.ow2.petals.se.eip.patterns.SourceKind;
import org.ow2.petals.se.eip.patterns.mock.ExchangeImplMock;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class BridgeTest
extends AbstractMEPBridgeWithUnicConsumesPatternTest {
    private Document in1;
    private Document out1;

    @Override
    public List<Param> getParamList() {
        return new CopyOnWriteArrayList<Param>();
    }

    @Override
    @Test
    public void testInit() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncDOM() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.out1), (String)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncStream() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractMEPBridgeWithUnicConsumesPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.out1), (String)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessDOM() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessStream() {
        try {
            this.abstractMEPBridgeWithUnicConsumesPattern.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.abstractMEPBridgeWithUnicConsumesPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.abstractMEPBridgeWithUnicConsumesPattern = new Bridge();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = Bridge.class.getResourceAsStream("/bridgeIn1.xml");
            this.in1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Bridge.class.getResourceAsStream("/bridgeOut1.xml");
            this.out1 = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.in1 = null;
        this.out1 = null;
    }

    private List<Consumes> getConsumesList(MEPType mepType) {
        CopyOnWriteArrayList<Consumes> consumesList = new CopyOnWriteArrayList<Consumes>();
        QName interfaceName = null;
        QName serviceName = null;
        String endpoint = null;
        interfaceName = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test1"));
        consumesList.add(consumes);
        return consumesList;
    }
}

