/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.AbstractTest;
import org.ow2.petals.se.eip.patterns.Dispatcher;
import org.ow2.petals.se.eip.patterns.RoutingSlip;
import org.ow2.petals.se.eip.patterns.SourceKind;
import org.ow2.petals.se.eip.patterns.mock.ExchangeImplMock;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class DispatcherTest
extends AbstractTest {
    private Dispatcher dispatcher;
    private Document in1;
    private Document out1;
    private Document out2;
    private Document fault1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dispatcher = new Dispatcher();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = RoutingSlip.class.getResourceAsStream("/dispatcherIn1.xml");
            this.in1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = RoutingSlip.class.getResourceAsStream("/dispatcherOut1.xml");
            this.out1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = RoutingSlip.class.getResourceAsStream("/dispatcherOut2.xml");
            this.out2 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = RoutingSlip.class.getResourceAsStream("/dispatcherFault1.xml");
            this.fault1 = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.dispatcher = null;
        this.in1 = null;
        this.out1 = null;
        this.out2 = null;
        this.fault1 = null;
    }

    @Test
    public void testProcessDOM() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.dispatcher);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessStream() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.dispatcher);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.in1), (String)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncDOM() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncStream() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2InOnlyWithDone() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)0L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2InOnlyWithErrorOnFirst() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2InOnlyWithErrorOnSecond() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)0L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2InOutWithOut() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2InOutWithFaultOnFirst() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2InOutWithFaultOnSecond() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2InOutWithFaultOnFirstAndFaultToException() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = true;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, true);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2InOutWithFaultOnSecondAndFaultToException() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = true;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, true);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2RobustInOnlyWithDone() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)0L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2RobustInOnlyWithErrorOnFirst() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2RobustInOnlyWithErrorOnSecond() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)0L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2RobustInOnlyWithFaultOnFirst() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2RobustInOnlyWithFaultOnSecond() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = false;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)0L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2RobustInOnlyWithFaultOnFirstAndFaultToException() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = true;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, true);
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncWith2RobustInOnlyWithFaultOnSecondAndFaultToException() {
        try {
            this.dispatcher.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            boolean faultToException = true;
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.dispatcher.getName(), consumesList.size(), false, false, true);
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)0L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.dispatcher, eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            XMLComparator.isEquivalent((String)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (String)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testInit() {
        try {
            this.dispatcher.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    @Override
    public List<Param> getParamList() {
        return new CopyOnWriteArrayList<Param>();
    }

    private List<Consumes> getConsumesList(MEPType mepType) {
        CopyOnWriteArrayList<Consumes> consumesList = new CopyOnWriteArrayList<Consumes>();
        QName interfaceName = null;
        QName serviceName = null;
        String endpoint = null;
        interfaceName = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test1"));
        consumesList.add(consumes);
        consumes.setOperation(new QName("http://petals.ow2.org", "test2"));
        consumesList.add(consumes);
        return consumesList;
    }
}

