/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathExpressionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.se.eip.patterns.PatternHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PatternHelperTest {
    Document patternHelperDocument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = PatternHelper.class.getResourceAsStream("/patternHelper.xml");
            this.patternHelperDocument = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        this.patternHelperDocument = null;
    }

    @Test
    public void testEvaluateXPathCondition() {
        String expression = null;
        boolean evaluation = false;
        try {
            expression = "/*[namespace-uri()='http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb' and local-name()='EnvoiESB']/*[namespace-uri()='' and local-name()='informationsGF']/*[namespace-uri()='' and local-name()='idEmetteur']='GF'";
            evaluation = PatternHelper.evaluateXPathCondition((String)expression, (Node)this.patternHelperDocument.getDocumentElement());
            Assert.assertTrue((boolean)evaluation);
            expression = "/*[namespace-uri()='http://finances.gouv.fr/dgme/esb/webapp/webservice/wsdl/envoiesb' and local-name()='EnvoiESB']/*[namespace-uri()='' and local-name()='informationsGF']/*[namespace-uri()='' and local-name()='idEmetteur']='MDEL'";
            evaluation = PatternHelper.evaluateXPathCondition((String)expression, (Node)this.patternHelperDocument.getDocumentElement());
            Assert.assertFalse((boolean)evaluation);
        }
        catch (XPathExpressionException e) {
            Assert.fail((String)("unable to evaluate: " + e.getMessage()));
        }
    }
}

