/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns.mock;

import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class ExchangeImplMock
implements Exchange {
    private final MessageExchange exchange;
    private NormalizedMessage inNormalizedExchange;
    private NormalizedMessage outNormalizedExchange;
    private boolean checkRole;
    private boolean checkStatus;

    public ExchangeImplMock(MessageExchange exchange) {
        this.exchange = exchange;
        this.inNormalizedExchange = this.exchange.getMessage("in");
        this.outNormalizedExchange = this.exchange.getMessage("out");
        this.checkRole = true;
        this.checkStatus = true;
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return this.exchange.createMessage();
    }

    public MessageExchange getMessageExchange() {
        try {
            if (this.inNormalizedExchange != null && this.exchange.getMessage("in") == null) {
                this.exchange.setMessage(this.inNormalizedExchange, "in");
            }
            if (this.outNormalizedExchange != null && this.exchange.getMessage("out") == null) {
                this.exchange.setMessage(this.outNormalizedExchange, "out");
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return this.exchange;
    }

    public Fault createFault() throws MessagingException {
        return this.exchange.createFault();
    }

    public ServiceEndpoint getEndpoint() {
        return this.exchange.getEndpoint();
    }

    public Exception getError() {
        return this.exchange.getError();
    }

    public String getExchangeId() {
        return this.exchange.getExchangeId();
    }

    public Fault getFault() {
        return this.exchange.getFault();
    }

    public QName getInterfaceName() {
        return this.exchange.getInterfaceName();
    }

    public QName getOperation() {
        return this.exchange.getOperation();
    }

    public URI getPattern() {
        return this.exchange.getPattern();
    }

    public Object getProperty(String name) {
        return this.exchange.getProperty(name);
    }

    public Set<?> getPropertyNames() {
        return this.exchange.getPropertyNames();
    }

    public MessageExchange.Role getRole() {
        return this.exchange.getRole();
    }

    public QName getService() {
        return this.exchange.getService();
    }

    public ExchangeStatus getStatus() {
        return this.exchange.getStatus();
    }

    public boolean isTransacted() {
        return this.exchange.isTransacted();
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.exchange.setEndpoint(endpoint);
    }

    public void setError(Exception error) {
        String packageName = error.getClass().getPackage().getName();
        if (!(packageName.startsWith("java") || packageName.startsWith("org.w3c") || packageName.startsWith("org.xml"))) {
            throw new IllegalArgumentException("Exception of type '" + packageName + "' are not supported by the JBI container");
        }
        this.exchange.setError(error);
    }

    public void setFault(Fault fault) throws MessagingException {
        this.exchange.setFault(fault);
    }

    public void setFault(Throwable e) throws MessagingException {
        Fault fault = this.exchange.createFault();
        Document faultDocument = SourceUtil.createSoapFaultDocument((Throwable)e, (QName)Exchange.DEFAULT_FAULT_QNAME);
        if (SourceUtil.isDOM3((Document)faultDocument)) {
            fault.setContent((Source)SourceUtil.createDOMSource((Document)faultDocument));
        } else {
            try {
                fault.setContent((Source)SourceUtil.createStreamSource((Document)faultDocument));
            }
            catch (PEtALSCDKException e1) {
                throw new MessagingException((Throwable)e1);
            }
        }
        this.exchange.setFault(fault);
    }

    public void setInterfaceName(QName interfaceName) {
        this.exchange.setInterfaceName(interfaceName);
    }

    public void setOperation(QName name) {
        this.exchange.setOperation(name);
    }

    public void setProperty(String name, Object obj) {
        this.exchange.setProperty(name, obj);
    }

    public void setService(QName service) {
        this.exchange.setService(service);
    }

    public void setStatus(ExchangeStatus status) throws MessagingException {
        this.checkStatus(status);
        this.exchange.setStatus(status);
    }

    private static final void copyAttachements(Map<String, DataHandler> attachments, NormalizedMessage normalizedMesg) throws MessagingException {
        for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
            normalizedMesg.addAttachment(entry.getKey(), entry.getValue());
        }
    }

    public void setOutMessageAttachments(Map<String, DataHandler> attachments) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        ExchangeImplMock.copyAttachements(attachments, outMess);
        this.setOutMessage(outMess);
    }

    public void setInMessageAttachments(Map<String, DataHandler> attachments) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        ExchangeImplMock.copyAttachements(attachments, inMess);
        this.setInMessage(inMess);
    }

    public Set<DataHandler> getInMessageAttachments() throws MessagingException {
        HashSet<DataHandler> attachments = new HashSet<DataHandler>();
        NormalizedMessage inMessage = this.getInMessage();
        if (inMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        Set names = inMessage.getAttachmentNames();
        for (Object attachId : names) {
            DataHandler dh = inMessage.getAttachment((String)attachId);
            if (dh == null) continue;
            attachments.add(dh);
        }
        return attachments;
    }

    public URI getExchangePattern() throws MessagingException {
        URI pattern = this.exchange.getPattern();
        if (pattern == null) {
            throw new MessagingException("You must specify a message exchange pattern in the message exchange");
        }
        return pattern;
    }

    public String getOperationName() {
        QName operation = this.exchange.getOperation();
        if (operation == null) {
            return null;
        }
        return operation.getLocalPart();
    }

    public String getEndpointName() throws MessagingException {
        ServiceEndpoint ep = this.exchange.getEndpoint();
        if (ep == null) {
            throw new MessagingException("You must specify an endpoint in the message exchange");
        }
        return ep.getEndpointName();
    }

    public NormalizedMessage getInMessage() {
        if (this.inNormalizedExchange == null) {
            if (this.exchange.getMessage("in") != null) {
                return this.exchange.getMessage("in");
            }
            try {
                this.inNormalizedExchange = this.exchange.createMessage();
                this.exchange.setMessage(this.inNormalizedExchange, "in");
            }
            catch (MessagingException e) {
                return null;
            }
        }
        return this.inNormalizedExchange;
    }

    public boolean isInMessage() {
        return this.exchange.getMessage("in") != null && this.exchange.getMessage("in").getContent() != null || this.inNormalizedExchange != null && this.inNormalizedExchange.getContent() != null;
    }

    public void setInMessage(NormalizedMessage msg) throws MessagingException {
        this.checkPatternMatching("in");
        this.checkRoleMatching("in");
        this.inNormalizedExchange = msg;
    }

    public NormalizedMessage getOutMessage() {
        if (this.outNormalizedExchange == null) {
            if (this.exchange.getMessage("out") != null) {
                return this.exchange.getMessage("out");
            }
            try {
                this.outNormalizedExchange = this.exchange.createMessage();
                this.exchange.setMessage(this.outNormalizedExchange, "out");
            }
            catch (MessagingException e) {
                return null;
            }
        }
        return this.outNormalizedExchange;
    }

    public boolean isOutMessage() {
        return this.exchange.getMessage("out") != null && this.exchange.getMessage("out").getContent() != null || this.outNormalizedExchange != null && this.outNormalizedExchange.getContent() != null;
    }

    public void setOutMessage(NormalizedMessage msg) throws MessagingException {
        this.checkPatternMatching("out");
        this.checkRoleMatching("out");
        this.outNormalizedExchange = msg;
    }

    public void setDoneStatus() throws MessagingException {
        this.setStatus(ExchangeStatus.DONE);
    }

    public boolean isDoneStatus() {
        return ExchangeStatus.DONE.equals(this.getStatus());
    }

    public void setErrorStatus() throws MessagingException {
        this.setStatus(ExchangeStatus.ERROR);
    }

    public boolean isErrorStatus() {
        return ExchangeStatus.ERROR.equals(this.getStatus());
    }

    public void setActiveStatus() throws MessagingException {
        this.setStatus(ExchangeStatus.ACTIVE);
    }

    public boolean isActiveStatus() {
        return ExchangeStatus.ACTIVE.equals(this.getStatus());
    }

    public boolean isProviderRole() {
        return MessageExchange.Role.PROVIDER.equals(this.getRole());
    }

    public boolean isConsumerRole() {
        return MessageExchange.Role.CONSUMER.equals(this.getRole());
    }

    public boolean isInOnlyPattern() {
        return Message.MEPConstants.IN_ONLY_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isRobustInOnlyPattern() {
        return Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isInOutPattern() {
        return Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isInOptionalOutPattern() {
        return Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN.equals(this.exchange.getPattern());
    }

    public void setCheckRole(boolean checkRole) {
        this.checkRole = checkRole;
        ((MessageExchangeMock)this.exchange).setCheckRole(checkRole);
    }

    public void setCheckStatus(boolean checkStatus) {
        this.checkStatus = checkStatus;
    }

    protected void checkPatternMatching(String name) throws MessagingException {
        if (name == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if ("out".equalsIgnoreCase(name) && (Message.MEPConstants.IN_ONLY_PATTERN.equals(this.exchange.getPattern()) || Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.exchange.getPattern()))) {
            throw new MessagingException("the MessageExchange state does not allow this operation.");
        }
    }

    protected void checkRoleMatching(String name) throws MessagingException {
        if (name == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if (!this.checkRole) {
            return;
        }
        if (MessageExchange.Role.CONSUMER.equals(this.exchange.getRole()) ? "in".equalsIgnoreCase(name) : MessageExchange.Role.PROVIDER.equals(this.exchange.getRole()) && "out".equalsIgnoreCase(name)) {
            return;
        }
        throw new MessagingException("The Role does not allow this operation.");
    }

    public Object getInMessageProperty(String name) throws MessagingException {
        NormalizedMessage nm = this.getInMessage();
        if (nm == null) {
            throw new MessagingException("In message must not be null");
        }
        return nm.getProperty(name);
    }

    public Object getOutMessageProperty(String name) throws MessagingException {
        NormalizedMessage nm = this.getOutMessage();
        if (nm == null) {
            throw new MessagingException("Out message must not be null");
        }
        return nm.getProperty(name);
    }

    public Set<?> getOutMessagePropertyNames() throws MessagingException {
        NormalizedMessage nm = this.getOutMessage();
        if (nm == null) {
            throw new MessagingException("Out message must not be null");
        }
        return nm.getPropertyNames();
    }

    public void setInMessageProperty(String name, Object value) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        inMess.setProperty(name, value);
        this.setInMessage(inMess);
    }

    private static final void copyProperties(Map<String, Object> properties, NormalizedMessage normalizedMsg) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            normalizedMsg.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public void setInMessageProperties(Map<String, Object> properties) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        ExchangeImplMock.copyProperties(properties, inMess);
        this.setInMessage(inMess);
    }

    public void setOutMessageProperties(Map<String, Object> properties) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        ExchangeImplMock.copyProperties(properties, outMess);
        this.setOutMessage(outMess);
    }

    public void setOutMessageProperty(String name, Object value) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        outMess.setProperty(name, value);
        this.setOutMessage(outMess);
    }

    public void addOutMessageAttachment(String id, DataHandler content) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        outMess.addAttachment(id, content);
        this.setOutMessage(outMess);
    }

    public void addInMessageAttachment(String id, DataHandler content) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        inMess.addAttachment(id, content);
        this.setInMessage(inMess);
    }

    public void setInSubject(Subject subject) {
        this.getInMessage().setSecuritySubject(subject);
    }

    public void setOutSubject(Subject subject) {
        this.getOutMessage().setSecuritySubject(subject);
    }

    public Map<QName, String> getInAddressing() {
        throw new NotImplementedException();
    }

    public void setInAddressing(Map<QName, String> addressing) {
        throw new NotImplementedException();
    }

    private void checkStatus(ExchangeStatus status) throws MessagingException {
        if (this.checkStatus && ExchangeStatus.DONE.equals(status)) {
            if (MessageExchange.Role.CONSUMER.equals(this.exchange.getRole())) {
                if (Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern()) && this.getFault() == null && this.exchange.getMessage("out") == null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
            } else {
                if (Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.exchange.getPattern()) && this.getFault() != null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern())) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN.equals(this.exchange.getPattern())) {
                    if (this.exchange.getFault() != null && this.exchange.getMessage("out") == null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                    if (this.exchange.getFault() == null && this.exchange.getMessage("out") != null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                }
            }
        }
    }

    public DataHandler getInMessageAttachment(String name) throws MessagingException {
        throw new NotImplementedException();
    }

    public Set<String> getInMessageAttachmentNames() throws MessagingException {
        throw new NotImplementedException();
    }

    public Subject getInSubject() throws MessagingException {
        throw new NotImplementedException();
    }

    public DataHandler getOutMessageAttachment(String name) throws MessagingException {
        throw new NotImplementedException();
    }

    public Set<String> getOutMessageAttachmentNames() throws MessagingException {
        throw new NotImplementedException();
    }

    public Set<DataHandler> getOutMessageAttachments() throws MessagingException {
        throw new NotImplementedException();
    }

    public Subject getOutSubject() throws MessagingException {
        throw new NotImplementedException();
    }

    public void setInMessageAttachment(String name, DataHandler attachement) throws MessagingException {
        throw new NotImplementedException();
    }

    public void setOutMessageAttachment(String name, DataHandler attachment) throws MessagingException {
        throw new NotImplementedException();
    }

    public Set<String> getInMessagePropertyNames() throws MessagingException {
        throw new NotImplementedException();
    }

    public Document getInMessageContentAsDocument() throws MessagingException {
        throw new NotImplementedException();
    }

    public Document getInMessageContentAsDocument(boolean forkSourceStream) throws MessagingException {
        throw new NotImplementedException();
    }

    public Source getInMessageContentAsSource() throws MessagingException {
        throw new NotImplementedException();
    }

    public Document getOutMessageContentAsDocument() throws MessagingException {
        throw new NotImplementedException();
    }

    public Document getOutMessageContentAsDocument(boolean forkSourceStream) throws MessagingException {
        throw new NotImplementedException();
    }

    public Source getOutMessageContentAsSource() throws MessagingException {
        throw new NotImplementedException();
    }

    public void setInMessageContent(Document inContent) throws MessagingException {
        throw new NotImplementedException();
    }

    public void setInMessageContent(InputStream inContent) throws MessagingException {
        throw new NotImplementedException();
    }

    public void setInMessageContent(Source inContent) throws MessagingException {
        throw new NotImplementedException();
    }

    public void setOutMessageContent(Document outContent) throws MessagingException {
        throw new NotImplementedException();
    }

    public void setOutMessageContent(InputStream inContent) throws MessagingException {
        throw new NotImplementedException();
    }

    public void setOutMessageContent(Source outContent) throws MessagingException {
        throw new NotImplementedException();
    }

    public FlowAttributes getFlowAttributes() {
        throw new NotImplementedException();
    }
}

