/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.Pattern;

public abstract class AbstractPattern
implements Pattern {
    protected Logger logger;

    @Override
    public final boolean processPattern(Exchange exchange, ExchangeContext context) {
        boolean result = true;
        if (this.logger == null) {
            this.logger = context.getLogger();
            if (this.logger == null) {
                this.logger = Logger.getLogger(AbstractPattern.class.getName());
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.getName() + ": processing the pattern");
        }
        if (this.validateMEPPattern(exchange) && exchange.isActiveStatus()) {
            result = this.process(exchange, context);
        }
        return result;
    }

    @Override
    public final boolean processAsyncPattern(Exchange exchange, ExchangeContext context, CommonAsyncContext asyncContext, boolean expired) {
        block12: {
            if (this.logger == null) {
                this.logger = context.getLogger();
                if (this.logger == null) {
                    this.logger = Logger.getLogger(AbstractPattern.class.getName());
                }
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.getName() + ": processing asynchronously the pattern");
            }
            try {
                if (expired) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(this.getName() + ": the process is expired");
                    }
                    this.processExpiredAsync(exchange, context, asyncContext);
                } else {
                    this.processAsync(exchange, context, asyncContext);
                }
            }
            catch (MessagingException e) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.getName() + ": failed to process the async pattern, " + e.getMessage());
                }
                if (exchange.isActiveStatus()) {
                    exchange.setError((Exception)((Object)e));
                }
            }
            catch (PEtALSCDKException e) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.getName() + ": failed to process the async pattern, " + e.getMessage());
                }
                if (!exchange.isActiveStatus()) break block12;
                exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
            }
        }
        return false;
    }

    protected final void logSend(Consumes consumedService, Exchange exchange) {
        if (this.logger.isLoggable(Level.FINE)) {
            String interfaceName = null;
            String serviceName = null;
            if (consumedService.getInterfaceName() != null) {
                interfaceName = consumedService.getInterfaceName().toString();
            }
            if (consumedService.getServiceName() != null) {
                serviceName = consumedService.getServiceName().toString();
            }
            this.logger.fine(this.getName() + ": invocation of the service : interface name=" + interfaceName + " / service name=" + serviceName + " / endpoint name=" + consumedService.getEndpointName());
        }
    }

    public abstract boolean process(Exchange var1, ExchangeContext var2);

    public abstract boolean processAsync(Exchange var1, ExchangeContext var2, CommonAsyncContext var3);

    public boolean processExpiredAsync(Exchange exchange, ExchangeContext context, CommonAsyncContext asyncContext) throws MessagingException, PEtALSCDKException {
        exchange.setError((Exception)((Object)new MessagingException("Failed to process the asynchronous pattern, timeout reached!")));
        return true;
    }

    public abstract boolean validateMEP(URI var1);

    protected boolean isFaultRobust(ConfigurationExtensions extensions) {
        for (String param : extensions.keySet()) {
            if (!"fault-robust".equals(param)) continue;
            return extensions.get((Object)param).equals("true");
        }
        return false;
    }

    protected boolean isExceptionRobust(ConfigurationExtensions extensions) {
        for (String param : extensions.keySet()) {
            if (!"exception-robust".equals(param)) continue;
            return extensions.get((Object)param).equals("true");
        }
        return false;
    }

    protected boolean isFaultToException(ConfigurationExtensions extensions) {
        for (String param : extensions.keySet()) {
            if (!"fault-to-exception".equals(param)) continue;
            return extensions.get((Object)param).equals("true");
        }
        return false;
    }

    protected boolean isAttachmentMode(ConfigurationExtensions extensions) {
        for (String param : extensions.keySet()) {
            if (!"attachment-mode".equals(param)) continue;
            return extensions.get((Object)param).equals("true");
        }
        return false;
    }

    private final boolean validateMEPPattern(Exchange exchange) {
        boolean result = true;
        URI pattern = null;
        try {
            pattern = exchange.getExchangePattern();
        }
        catch (MessagingException e) {
            exchange.setError((Exception)((Object)e));
        }
        if (!this.validateMEP(pattern)) {
            exchange.setError((Exception)((Object)new MessagingException("The " + this.getName() + " pattern does not support " + pattern + " pattern")));
            result = false;
        }
        return result;
    }

    public abstract String getNameSpace();
}

