/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import java.net.URI;
import java.util.List;
import javax.jbi.messaging.MessagingException;
import javax.xml.xpath.XPathExpressionException;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.ExchangeUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractMEPBridgeWithUnicConsumesPattern;
import org.ow2.petals.se.eip.patterns.OperationRouterEngine;
import org.ow2.petals.se.eip.patterns.PatternHelper;
import org.ow2.petals.se.eip.patterns.RouterEngine;
import org.ow2.petals.se.eip.patterns.XPathRouterEngine;

public class Router
extends AbstractMEPBridgeWithUnicConsumesPattern {
    public static final String ROUTER_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/router";
    private XPathRouterEngine xpathRouterEngine = new XPathRouterEngine();
    private OperationRouterEngine operationRouterEngine = new OperationRouterEngine();

    @Override
    public boolean process(Exchange exchange, ExchangeContext context) {
        RouterEngine routerEngine;
        List<Consumes> consumesList = context.getSUConsumes(exchange.getEndpoint());
        List<String> conditions = this.operationRouterEngine.getOperationParameters(context.getExtensions());
        if (conditions.isEmpty()) {
            conditions = this.xpathRouterEngine.getXpathParameters(context.getExtensions());
            routerEngine = this.xpathRouterEngine;
        } else {
            routerEngine = this.operationRouterEngine;
        }
        if (conditions.isEmpty()) {
            exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must at least one routing parameter")));
        }
        try {
            if (consumesList != null) {
                if (consumesList.size() == conditions.size() + 1) {
                    int consumesIndex = routerEngine.route(conditions, exchange);
                    Consumes consumedService = consumesList.get(consumesIndex);
                    Exchange routedExchange = context.createConsumeExchange(consumedService);
                    if (routedExchange.getOperation() == null) {
                        routedExchange.setOperation(exchange.getOperation());
                    }
                    PatternHelper.copy(exchange.getInMessage(), routedExchange.getInMessage());
                    ExchangeUtil.copyExchangeProperties((Exchange)exchange, (Exchange)routedExchange);
                    this.logSend(consumedService, routedExchange);
                    boolean faultRobust = this.isFaultToException(context.getExtensions());
                    CommonAsyncContext asyncContext = new CommonAsyncContext(exchange, 600000L, this.getName(), 1, false, false, faultRobust);
                    context.sendAsync(routedExchange, asyncContext);
                } else {
                    exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define (numberOfRoutingParameters+1) Consumes sections")));
                }
            } else {
                exchange.setError((Exception)((Object)new MessagingException(this.getName() + ": the Service Unit must define (numberOfRoutingParameters+2) Consumes sections")));
            }
        }
        catch (MessagingException e) {
            exchange.setError((Exception)((Object)e));
        }
        catch (PEtALSCDKException e) {
            exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)))));
        }
        catch (XPathExpressionException e) {
            exchange.setError((Exception)e);
        }
        catch (IllegalArgumentException e) {
            exchange.setError((Exception)e);
        }
        return false;
    }

    @Override
    public String getName() {
        return "Router";
    }

    @Override
    public boolean validateMEP(URI mep) {
        return true;
    }

    @Override
    public void init() {
    }

    @Override
    public String getNameSpace() {
        return ROUTER_NAMESPACE;
    }
}

