/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.quartz;

import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.listener.AbstractExternalListener;
import org.ow2.petals.se.quartz.QuartzSe;
import org.ow2.petals.se.quartz.job.EmitSignalJob;
import org.ow2.petals.se.quartz.utils.QuartzUtils;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class QuartzExternalListener
extends AbstractExternalListener {
    public void start() throws PEtALSCDKException {
        String jobName = QuartzUtils.generateJobName(this.getConsumes());
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Defining a new job " + jobName + ".");
        }
        Scheduler scheduler = ((QuartzSe)this.getComponent()).getQuartzScheduler();
        String cronExpression = this.getExtensions().get((Object)"cron-expression");
        if (cronExpression != null) {
            cronExpression = cronExpression.trim();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("The CRON expression is: " + cronExpression);
        }
        try {
            JobDetail jobDetail = new JobDetail(jobName, "DEFAULT", EmitSignalJob.class);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put((Object)"SchedulerManager", (Object)this);
            jobDetail.setJobDataMap(jobDataMap);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("The " + jobName + " job was successfully created.");
            }
            String triggerName = QuartzUtils.generateTriggerName(this.getConsumes());
            CronTrigger trigger = new CronTrigger(triggerName, "DEFAULT", cronExpression);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("The CRON trigger was successfully created.");
            }
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("The CRON trigger was successfully applied to the " + jobName + " job.");
            }
        }
        catch (SchedulerException e) {
            throw new PEtALSCDKException("The " + jobName + " job could not be associated with a CRON trigger.", (Throwable)e);
        }
        catch (ParseException e) {
            throw new PEtALSCDKException("A CRON trigger could not be created for the " + jobName + " job.", (Throwable)e);
        }
    }

    public void stop() throws PEtALSCDKException {
        String jobName = QuartzUtils.generateJobName(this.getConsumes());
        Scheduler scheduler = ((QuartzSe)this.getComponent()).getQuartzScheduler();
        try {
            scheduler.deleteJob(jobName, "DEFAULT");
            Logger logger = this.getLogger();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("The " + jobName + " job was successfully removed.");
            }
        }
        catch (SchedulerException e) {
            throw new PEtALSCDKException("The " + jobName + " job could not be removed.", (Throwable)e);
        }
    }
}

