/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import com.ebmwebsourcing.easycommons.xml.DOMHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlReaders;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlWriters;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfEndpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfService;
import org.ow2.petals.component.framework.util.EndpointUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class WSDLUtilImpl {
    public static final Description createLightWSDL20Description(QName interfaceQName, QName serviceQName, String endpointName) throws WSDLException {
        if (!interfaceQName.getNamespaceURI().equals(serviceQName.getNamespaceURI())) {
            throw new WSDLException("The interface namespace '" + interfaceQName.getNamespaceURI() + "' must be the same than the service namespace '" + serviceQName.getNamespaceURI() + "' to build a light WSDL");
        }
        Description wsdlDescription = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description((AbsItfDescription)WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL20));
        wsdlDescription.setTargetNamespace(interfaceQName.getNamespaceURI());
        wsdlDescription.setQName(new QName("autoGenerated"));
        InterfaceType interfazz = (InterfaceType)wsdlDescription.createInterface();
        interfazz.setQName(interfaceQName);
        wsdlDescription.addInterface((AbsItfInterfaceType)interfazz);
        Service service = (Service)wsdlDescription.createService();
        service.setQName(serviceQName);
        service.setInterface((AbsItfInterfaceType)interfazz);
        Endpoint endpoint = (Endpoint)service.createEndpoint();
        endpoint.setName(endpointName);
        service.addEndpoint((AbsItfEndpoint)endpoint);
        wsdlDescription.addService((AbsItfService)service);
        return wsdlDescription;
    }

    public static final List<Endpoint> getEndpointList(Description wsdlDescription, QName serviceQNameFilter, String endpointNameFilter) {
        ArrayList<Endpoint> endpointList = new ArrayList<Endpoint>();
        Endpoint endpoint = null;
        if (wsdlDescription != null) {
            if (serviceQNameFilter == null) {
                List serviceList = wsdlDescription.getServices();
                for (Service service : serviceList) {
                    if (service == null) continue;
                    if (endpointNameFilter == null) {
                        endpointList.addAll(service.getEndpoints());
                        continue;
                    }
                    endpoint = (Endpoint)service.getEndpoint(endpointNameFilter);
                    if (endpoint == null) continue;
                    endpointList.add((Endpoint)service.getEndpoint(endpointNameFilter));
                }
            } else {
                Service service = (Service)wsdlDescription.getService(serviceQNameFilter);
                if (service != null) {
                    if (endpointNameFilter == null) {
                        endpointList.addAll(service.getEndpoints());
                    } else {
                        endpoint = (Endpoint)service.getEndpoint(endpointNameFilter);
                        if (endpoint != null) {
                            endpointList.add((Endpoint)service.getEndpoint(endpointNameFilter));
                        }
                    }
                }
            }
        }
        return endpointList;
    }

    public static final List<Endpoint> getEndpointList(Description wsdlDescription) {
        return WSDLUtilImpl.getEndpointList(wsdlDescription, null, null);
    }

    public static final Description createWsdlDescription(URL wsdlLocation) throws WSDLException {
        return WSDLUtilImpl.createWsdlDescription(wsdlLocation, false, true);
    }

    public static final Description createWsdlDescription(URL wsdlLocation, boolean processAutogenerateEndpoint) throws WSDLException {
        return WSDLUtilImpl.createWsdlDescription(wsdlLocation, processAutogenerateEndpoint, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Description createWsdlDescription(URL wsdlLocation, boolean processAutogenerateEndpoint, boolean addImportedDocumentsInWsdl) throws WSDLException {
        Description description;
        block11: {
            String autogeneratedEndpointName = null;
            if (wsdlLocation == null) {
                return null;
            }
            WSDL4ComplexWsdlReader wsdl4ComplexWsdlReader = null;
            try {
                wsdl4ComplexWsdlReader = WSDL4ComplexWsdlReaders.takeWSDL4ComplexWsdlReader();
                Description description2 = wsdl4ComplexWsdlReader.read(wsdlLocation);
                if (addImportedDocumentsInWsdl) {
                    description2.addImportedDocumentsInWsdl();
                }
                if (processAutogenerateEndpoint) {
                    List<Endpoint> endpointList = WSDLUtilImpl.getEndpointList(description2, null, "autogenerate");
                    for (Endpoint endpoint : endpointList) {
                        autogeneratedEndpointName = EndpointUtil.generateEndpointName();
                        endpoint.setName(autogeneratedEndpointName);
                    }
                }
                description = description2;
                if (wsdl4ComplexWsdlReader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (wsdl4ComplexWsdlReader != null) {
                        WSDL4ComplexWsdlReaders.releaseWSDL4ComplexWsdlReader((WSDL4ComplexWsdlReader)wsdl4ComplexWsdlReader);
                    }
                    throw throwable;
                }
                catch (URISyntaxException e) {
                    throw new WSDLException("Failed to parse the WSDL", (Throwable)e);
                }
                catch (IOException e) {
                    throw new WSDLException("Failed to read the WSDL", (Throwable)e);
                }
            }
            WSDL4ComplexWsdlReaders.releaseWSDL4ComplexWsdlReader((WSDL4ComplexWsdlReader)wsdl4ComplexWsdlReader);
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Document convertDescriptionToDocument(Description wsdlDescription) throws WSDLException {
        WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter = null;
        try {
            Document document;
            wsdl4ComplexWsdlWriter = WSDL4ComplexWsdlWriters.takeWSDL4ComplexWsdlWriter();
            Document document2 = document = wsdl4ComplexWsdlWriter.getDocument(wsdlDescription);
            return document2;
        }
        finally {
            if (wsdl4ComplexWsdlWriter != null) {
                WSDL4ComplexWsdlWriters.releaseWSDL4ComplexWsdlWriter((WSDL4ComplexWsdlWriter)wsdl4ComplexWsdlWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String convertDescriptionToString(Description wsdlDescription) throws WSDLException {
        WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter = null;
        try {
            String string;
            wsdl4ComplexWsdlWriter = WSDL4ComplexWsdlWriters.takeWSDL4ComplexWsdlWriter();
            String string2 = string = wsdl4ComplexWsdlWriter.writeWSDL4ComplexWsdl(wsdlDescription);
            return string2;
        }
        finally {
            if (wsdl4ComplexWsdlWriter != null) {
                WSDL4ComplexWsdlWriters.releaseWSDL4ComplexWsdlWriter((WSDL4ComplexWsdlWriter)wsdl4ComplexWsdlWriter);
            }
        }
    }

    public static final boolean isDescriptionContaining(Description wsdlDescription, ServiceEndpoint endpoint) {
        if (endpoint == null || endpoint.getServiceName() == null || endpoint.getEndpointName() == null) {
            return false;
        }
        return !WSDLUtilImpl.getEndpointList(wsdlDescription, endpoint.getServiceName(), endpoint.getEndpointName()).isEmpty();
    }

    public static final void convertDescriptionToFile(Description description, File wsdlFile) throws WSDLException {
        Document wsdlDocument = WSDLUtilImpl.convertDescriptionToDocument(description);
        try {
            DOMHelper.prettyPrint((Node)wsdlDocument, (OutputStream)new FileOutputStream(wsdlFile));
        }
        catch (FileNotFoundException e) {
            throw new WSDLException("Failed to write the WSDL", (Throwable)e);
        }
    }

    public static final List<QName> getEndpointOperations(Description wsdlDescription, QName serviceName, String endpointName) {
        InterfaceType interfaceType;
        assert (wsdlDescription != null);
        assert (serviceName != null);
        assert (endpointName != null && !endpointName.isEmpty());
        ArrayList<QName> operations = new ArrayList<QName>();
        List<Endpoint> endpoints = WSDLUtilImpl.getEndpointList(wsdlDescription, serviceName, endpointName);
        assert (endpoints != null && endpoints.size() == 1);
        Binding binding = (Binding)endpoints.get(0).getBinding();
        if (binding != null && (interfaceType = (InterfaceType)binding.getInterface()) != null && interfaceType.getOperations() != null) {
            for (Operation operation : interfaceType.getOperations()) {
                operations.add(operation.getQName());
            }
        }
        return operations;
    }
}

