/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.api.abstractElmt;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaReader;

public abstract class AbstractIncludeImpl<E, S extends AbsItfSchema>
extends AbstractSchemaElementImpl<E>
implements AbsItfInclude<S> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractIncludeImpl.class.getName());
    private final Map<SchemaReader.FeatureConstants, Object> features;
    private final Map<URI, AbsItfSchema> imports;
    private final URI baseURI;
    private final AbstractSchemaReader reader;
    private S schema;

    private AbstractIncludeImpl(E model, Map<SchemaReader.FeatureConstants, Object> features, AbstractSchemaElementImpl parent, Map<URI, AbsItfSchema> imports, URI baseURI, AbstractSchemaReader reader) throws SchemaException {
        super(model, parent);
        this.features = features != null ? features : (parent != null ? ((AbstractSchemaImpl)this.parent).getFeatures() : null);
        this.imports = imports;
        this.baseURI = baseURI;
        this.reader = reader;
    }

    public AbstractIncludeImpl(E model, Map<SchemaReader.FeatureConstants, Object> features, Map<URI, AbsItfSchema> imports, URI baseURI, AbstractSchemaReader reader) throws SchemaException {
        this(model, features, null, imports, baseURI, reader);
    }

    public AbstractIncludeImpl(E model, AbstractSchemaElementImpl parent, Map<URI, AbsItfSchema> imports, URI baseURI, AbstractSchemaReader reader) throws SchemaException {
        this(model, null, parent, imports, baseURI, reader);
    }

    private void retrieveInclude(URI schemaLocation, Map<SchemaReader.FeatureConstants, Object> features, Map<URI, AbsItfSchema> imports, URI baseURI, AbstractSchemaReader reader) throws SchemaException {
        assert (imports != null);
        if (schemaLocation == null) {
            return;
        }
        try {
            if (!imports.containsKey(schemaLocation)) {
                Schema externalSchema = reader.readExternalPart(schemaLocation, baseURI, imports);
                imports.put(schemaLocation, externalSchema);
                ((AbstractSchemaImpl)((Object)externalSchema)).initialize();
            }
            this.schema = imports.get(schemaLocation);
        }
        catch (SchemaException e) {
            throw new SchemaException("the imported document cannot be import at: " + schemaLocation.toString(), e);
        }
        catch (URISyntaxException e) {
            throw new SchemaException("the imported document cannot be import at: " + schemaLocation.toString() + " because the URI is invalid", e);
        }
        catch (MalformedURLException e) {
            throw new SchemaException("the imported document cannot be import at: " + schemaLocation.toString() + " because the URI is invalid", e);
        }
    }

    private boolean haveImportDocumentsFeature() {
        if (this.features == null) {
            return false;
        }
        Boolean importDocuments = (Boolean)this.features.get((Object)SchemaReader.FeatureConstants.IMPORT_DOCUMENTS);
        if (importDocuments == null) {
            return false;
        }
        return importDocuments;
    }

    @Override
    public S getSchema() {
        if (this.schema == null) {
            if (this.haveImportDocumentsFeature()) {
                try {
                    this.retrieveInclude(this.getLocationURI(), this.features, this.imports, this.baseURI, this.reader);
                }
                catch (SchemaException se) {
                    throw new RuntimeException(se);
                }
            }
            if (this.schema != null) {
                ((AbstractSchemaImpl)this.schema).setFeatures(this.features);
            }
        }
        return this.schema;
    }

    @Override
    public void setSchema(S schema) {
        this.schema = schema;
        if (this.schema != null) {
            ((AbstractSchemaImpl)this.getParentSchema()).addIncludeElementsInAllList(this);
        }
    }

    public S getParentSchema() {
        return (S)this.parent.getSchema();
    }
}

